/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.cloud;

import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.impl.cloud.BlacklistServiceFilter;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.impl.cloud.HealthyServiceFilter;
import org.apache.camel.spring.boot.cloud.CamelCloudAutoConfiguration;
import org.apache.camel.spring.boot.cloud.CamelCloudConfigurationProperties;
import org.apache.camel.spring.boot.cloud.CamelCloudServiceFilter;
import org.apache.camel.spring.boot.util.GroupCondition;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelCloudAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelCloudConfigurationProperties.class})
@Conditional(value={Condition.class})
public class CamelCloudServiceFilterAutoConfiguration
implements BeanFactoryAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelCloudServiceFilterAutoConfiguration.class);
    private BeanFactory beanFactory;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private CamelCloudConfigurationProperties configurationProperties;

    public void setBeanFactory(BeanFactory factory) throws BeansException {
        this.beanFactory = factory;
    }

    @Lazy
    @Bean(name={"service-filter"})
    public CamelCloudServiceFilter serviceFilter() {
        return this.createServiceFilter(this.configurationProperties.getServiceFilter());
    }

    @PostConstruct
    public void addServiceFilterConfigurations() {
        if (!(this.beanFactory instanceof ConfigurableBeanFactory)) {
            LOGGER.warn("BeanFactory is not of type ConfigurableBeanFactory");
            return;
        }
        ConfigurableBeanFactory factory = (ConfigurableBeanFactory)this.beanFactory;
        this.configurationProperties.getServiceFilter().getConfigurations().entrySet().stream().forEach(entry -> this.registerBean(factory, (String)entry.getKey(), (CamelCloudConfigurationProperties.ServiceFilterConfiguration)entry.getValue()));
    }

    private void registerBean(ConfigurableBeanFactory factory, String name, CamelCloudConfigurationProperties.ServiceFilterConfiguration configuration) {
        factory.registerSingleton(name, (Object)this.createServiceFilter(configuration));
    }

    private CamelCloudServiceFilter createServiceFilter(CamelCloudConfigurationProperties.ServiceFilterConfiguration configuration) {
        BlacklistServiceFilter blacklist = new BlacklistServiceFilter();
        Map<String, List<String>> services = configuration.getBlacklist();
        for (Map.Entry<String, List<String>> entry : services.entrySet()) {
            for (String part : entry.getValue()) {
                String host = StringHelper.before((String)part, (String)":");
                String port = StringHelper.after((String)part, (String)":");
                if (!ObjectHelper.isNotEmpty((String)host) || !ObjectHelper.isNotEmpty((String)port)) continue;
                blacklist.addServer(DefaultServiceDefinition.builder().withName(entry.getKey()).withHost(host).withPort(Integer.valueOf(Integer.parseInt(port))).build());
            }
        }
        return new CamelCloudServiceFilter(Arrays.asList(new HealthyServiceFilter(), blacklist));
    }

    public static class Condition
    extends GroupCondition {
        public Condition() {
            super("camel.cloud", "camel.cloud.service-filter");
        }
    }
}

