/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.util;

import java.util.Arrays;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class HierarchicalCondition
extends SpringBootCondition {
    private final String[] items;

    public HierarchicalCondition(String ... items) {
        this.items = Arrays.copyOf(items, items.length);
    }

    public ConditionOutcome getMatchOutcome(ConditionContext conditionContext, AnnotatedTypeMetadata annotatedTypeMetadata) {
        if (this.items.length == 0) {
            return ConditionOutcome.match((ConditionMessage)ConditionMessage.forCondition((String)"no condition", (Object[])new Object[0]).because("no conditions"));
        }
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)this.items[0], (Object[])new Object[0]);
        Environment environment = conditionContext.getEnvironment();
        return HierarchicalPropertiesEvaluator.evaluate(environment, this.items) ? ConditionOutcome.match((ConditionMessage)message.because("enabled")) : ConditionOutcome.noMatch((ConditionMessage)message.because("not enabled"));
    }
}

