/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.aot;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.camel.spring.boot.aot.RuntimeHintsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class CamelRuntimeHints
implements RuntimeHintsRegistrar {
    private static final Logger LOG = LoggerFactory.getLogger(CamelRuntimeHints.class);

    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
        hints.resources().registerPattern("org/apache/camel/main/*.properties");
        CamelRuntimeHints.registerCamelServices(hints, classLoader);
        hints.reflection().registerType(List.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
        hints.reflection().registerType(Collection.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS});
    }

    private static void registerCamelServices(RuntimeHints hints, ClassLoader classLoader) {
        hints.resources().registerPattern("META-INF/services/org/apache/camel/*");
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver(classLoader);
        try {
            for (Resource resource : resolver.getResources("classpath*:META-INF/services/org/apache/camel/**")) {
                String filename = resource.getFilename();
                if (filename == null || filename.isBlank() || filename.endsWith(".properties")) continue;
                try (BufferedReader reader = new BufferedReader(new StringReader(resource.getContentAsString(StandardCharsets.UTF_8)));){
                    String line = reader.readLine();
                    String prefixClass = "class=";
                    while (line != null) {
                        if (line.startsWith("#") || line.isBlank()) {
                            line = reader.readLine();
                            continue;
                        }
                        String className = line.trim();
                        if (line.startsWith(prefixClass)) {
                            className = line.substring(prefixClass.length());
                        }
                        LOG.debug("Found the class {} to register", (Object)className);
                        RuntimeHintsHelper.registerClassHierarchy(hints, classLoader, className, MemberCategory.INVOKE_PUBLIC_CONSTRUCTORS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INTROSPECT_DECLARED_METHODS, MemberCategory.INTROSPECT_PUBLIC_METHODS);
                        line = reader.readLine();
                    }
                }
            }
        }
        catch (IOException e) {
            LOG.debug("Could not load the Camel services: {}", (Object)e.getMessage());
        }
    }
}

