/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health.readiness;

import java.util.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheckHelper;
import org.apache.camel.spring.boot.actuate.health.CamelProbesHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.availability.ReadinessStateHealthIndicator;
import org.springframework.boot.availability.ApplicationAvailability;
import org.springframework.boot.availability.AvailabilityState;
import org.springframework.boot.availability.ReadinessState;

public class CamelReadinessStateHealthIndicator
extends ReadinessStateHealthIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(CamelReadinessStateHealthIndicator.class);
    private final CamelContext camelContext;

    public CamelReadinessStateHealthIndicator(ApplicationAvailability availability, CamelContext camelContext) {
        super(availability);
        this.camelContext = camelContext;
    }

    protected AvailabilityState getState(ApplicationAvailability applicationAvailability) {
        Collection results = HealthCheckHelper.invokeReadiness((CamelContext)this.camelContext);
        boolean isReady = CamelProbesHelper.checkProbeState(results, LOG);
        return isReady ? ReadinessState.ACCEPTING_TRAFFIC : ReadinessState.REFUSING_TRAFFIC;
    }
}

