/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.routecontroller;

import org.apache.camel.impl.engine.DefaultSupervisingRouteController;
import org.apache.camel.spi.SupervisingRouteController;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.routecontroller.SupervisingRouteControllerConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.routecontroller", name={"enabled"})
@EnableConfigurationProperties(value={SupervisingRouteControllerConfiguration.class})
public class SupervisingRouteControllerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SupervisingRouteController supervisingRouteController(SupervisingRouteControllerConfiguration config) {
        DefaultSupervisingRouteController src = null;
        if (config.isEnabled()) {
            src = new DefaultSupervisingRouteController();
            if (config.getIncludeRoutes() != null) {
                src.setIncludeRoutes(config.getIncludeRoutes());
            }
            if (config.getExcludeRoutes() != null) {
                src.setExcludeRoutes(config.getExcludeRoutes());
            }
            if (config.getThreadPoolSize() > 0) {
                src.setThreadPoolSize(config.getThreadPoolSize());
            }
            if (config.getBackOffDelay() > 0L) {
                src.setBackOffDelay(config.getBackOffDelay());
            }
            if (config.getInitialDelay() > 0L) {
                src.setInitialDelay(config.getInitialDelay());
            }
            if (config.getBackOffMaxAttempts() > 0L) {
                src.setBackOffMaxAttempts(config.getBackOffMaxAttempts());
            }
            if (config.getBackOffMaxDelay() > 0L) {
                src.setBackOffMaxDelay(config.getBackOffMaxDelay());
            }
            if (config.getBackOffMaxElapsedTime() > 0L) {
                src.setBackOffMaxElapsedTime(config.getBackOffMaxElapsedTime());
            }
            if (config.getBackOffMultiplier() > 0.0) {
                src.setBackOffMultiplier(config.getBackOffMultiplier());
            }
            src.setUnhealthyOnExhausted(config.isUnhealthyOnExhausted());
            src.setUnhealthyOnRestarting(config.isUnhealthyOnRestarting());
        }
        return src;
    }
}

