/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckConfigurationProperties;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelHealthCheckConfigurationProperties.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelHealthCheckAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelHealthCheckAutoConfiguration.class);

    @Scope(value="singleton")
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={CamelHealthCheckIndicator.class})
    protected class CamelHealthCheckIndicatorInitializer {
        protected CamelHealthCheckIndicatorInitializer() {
        }

        @Bean(name={"camelHealth"})
        public HealthIndicator camelHealthCheckIndicator(CamelContext camelContext, CamelHealthCheckConfigurationProperties config) {
            HealthCheck hc;
            HealthCheckRegistry hcr;
            if (config != null && config.getEnabled() != null && !config.getEnabled().booleanValue()) {
                return null;
            }
            if (config == null) {
                config = new CamelHealthCheckConfigurationProperties();
            }
            if ((hcr = (HealthCheckRegistry)camelContext.getExtension(HealthCheckRegistry.class)) == null) {
                if (config.getEnabled() != null && config.getEnabled().booleanValue()) {
                    LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
                }
                return null;
            }
            hcr.setId("camel-spring-boot");
            if (config.getEnabled() != null) {
                hcr.setEnabled(config.getEnabled().booleanValue());
            }
            if (config.getExcludePattern() != null) {
                hcr.setExcludePattern(config.getExcludePattern());
            }
            if (config.getExposureLevel() != null) {
                hcr.setExposureLevel(config.getExposureLevel());
            }
            if (hcr.isEnabled() && (hc = (HealthCheck)hcr.resolveById("context")) != null) {
                hcr.register((Object)hc);
            }
            if (hcr.isEnabled() && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
                if (config.getRoutesEnabled() != null) {
                    hc.setEnabled(config.getRoutesEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            if (hcr.isEnabled() && (hc = hcr.getRepository("consumers").orElse((HealthCheckRepository)hcr.resolveById("consumers"))) != null) {
                if (config.getConsumersEnabled() != null) {
                    hc.setEnabled(config.getConsumersEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            if (hcr.isEnabled() && (hc = hcr.getRepository("registry").orElse((HealthCheckRepository)hcr.resolveById("registry"))) != null) {
                if (config.getRegistryEnabled() != null) {
                    hc.setEnabled(config.getRegistryEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            return new CamelHealthCheckIndicator(camelContext);
        }
    }
}

