/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.actuate.health;

import org.apache.camel.CamelContext;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckConfigurationProperties;
import org.apache.camel.spring.boot.actuate.health.CamelHealthCheckIndicator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={HealthIndicator.class})
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelHealthCheckConfigurationProperties.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelHealthCheckAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(CamelHealthCheckAutoConfiguration.class);

    @Scope(value="singleton")
    @ConditionalOnClass(value={CamelContext.class})
    @ConditionalOnMissingBean(value={CamelHealthCheckIndicator.class})
    protected class CamelHealthCheckIndicatorInitializer {
        protected CamelHealthCheckIndicatorInitializer() {
        }

        @Bean(name={"camelHealth"})
        public HealthIndicator camelHealthCheckIndicator(CamelContext camelContext, CamelHealthCheckConfigurationProperties config) {
            HealthCheck hc;
            HealthCheckRegistry hcr;
            if (config != null && config.getEnabled() != null && !config.getEnabled().booleanValue()) {
                return null;
            }
            if (config == null) {
                config = new CamelHealthCheckConfigurationProperties();
            }
            if ((hcr = (HealthCheckRegistry)camelContext.getExtension(HealthCheckRegistry.class)) == null) {
                LOG.warn("Cannot find HealthCheckRegistry from classpath. Add camel-health to classpath.");
                return null;
            }
            hcr.setId("camel-spring-boot");
            if (!(config.getConfig().containsKey("context") && config.getContextEnabled() == null || (hc = (HealthCheck)hcr.resolveById("context")) == null)) {
                if (config.getContextEnabled() != null) {
                    hc.getConfiguration().setEnabled(config.getContextEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            if (hcr.isEnabled() && (!config.getConfig().containsKey("routes") || config.getRoutesEnabled() != null) && (hc = hcr.getRepository("routes").orElse((HealthCheckRepository)hcr.resolveById("routes"))) != null) {
                if (config.getRoutesEnabled() != null) {
                    hc.setEnabled(config.getRoutesEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            if (hcr.isEnabled() && (!config.getConfig().containsKey("consumers") || config.getConsumersEnabled() != null) && (hc = hcr.getRepository("consumers").orElse((HealthCheckRepository)hcr.resolveById("consumers"))) != null) {
                if (config.getConsumersEnabled() != null) {
                    hc.setEnabled(config.getConsumersEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            if (hcr.isEnabled() && (!config.getConfig().containsKey("registry") || config.getRegistryEnabled() != null) && (hc = hcr.getRepository("registry").orElse((HealthCheckRepository)hcr.resolveById("registry"))) != null) {
                if (config.getRegistryEnabled() != null) {
                    hc.setEnabled(config.getRegistryEnabled().booleanValue());
                }
                hcr.register((Object)hc);
            }
            for (String id : config.getConfig().keySet()) {
                CamelHealthCheckConfigurationProperties.HealthCheckConfigurationProperties hcc = config.getConfig().get(id);
                String parent = hcc.getParent();
                if (parent == null) {
                    throw new IllegalArgumentException("HealthCheck with id: " + id + " must have parent configured");
                }
                Object hc2 = hcr.getCheck(id).orElse(null);
                if (hc2 == null) {
                    hc2 = hcr.resolveById(parent);
                    if (hc2 == null) {
                        LOG.warn("Cannot resolve HealthCheck with id: " + parent + " from classpath.");
                        continue;
                    }
                    hcr.register(hc2);
                }
                if (hc2 instanceof HealthCheck) {
                    ((HealthCheck)hc2).getConfiguration().setParent(hcc.getParent());
                    ((HealthCheck)hc2).getConfiguration().setEnabled(hcc.getEnabled() != null ? hcc.getEnabled() : true);
                    ((HealthCheck)hc2).getConfiguration().setFailureThreshold(hcc.getFailureThreshold().intValue());
                    ((HealthCheck)hc2).getConfiguration().setInterval(hcc.getInterval().longValue());
                    continue;
                }
                if (!(hc2 instanceof HealthCheckRepository)) continue;
                ((HealthCheckRepository)hc2).addConfiguration(id, hcc.toHealthCheckConfiguration());
            }
            return new CamelHealthCheckIndicator(camelContext);
        }
    }
}

