/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.CamelContext;
import org.apache.camel.StartupListener;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.apache.camel.main.MainDurationEventNotifier;
import org.apache.camel.main.RoutesCollector;
import org.apache.camel.main.RoutesConfigurer;
import org.apache.camel.spi.CamelEvent;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spring.boot.CamelConfigurationProperties;
import org.apache.camel.spring.boot.CamelContextConfiguration;
import org.apache.camel.spring.boot.CamelMainRunController;
import org.apache.camel.spring.boot.CamelSpringBootInitializationException;
import org.apache.camel.support.EventNotifierSupport;
import org.apache.camel.support.service.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class CamelSpringBootApplicationListener
implements ApplicationListener<ContextRefreshedEvent>,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(CamelSpringBootApplicationListener.class);
    private final ApplicationContext applicationContext;
    private final List<CamelContextConfiguration> camelContextConfigurations;
    private final CamelConfigurationProperties configurationProperties;
    private final RoutesCollector springBootRoutesCollector;

    public CamelSpringBootApplicationListener(ApplicationContext applicationContext, List<CamelContextConfiguration> camelContextConfigurations, CamelConfigurationProperties configurationProperties, RoutesCollector springBootRoutesCollector) {
        this.applicationContext = applicationContext;
        this.camelContextConfigurations = new ArrayList<CamelContextConfiguration>(camelContextConfigurations);
        this.configurationProperties = configurationProperties;
        this.springBootRoutesCollector = springBootRoutesCollector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onApplicationEvent(ContextRefreshedEvent event) {
        final CamelContext camelContext = (CamelContext)this.applicationContext.getBean(CamelContext.class);
        if (event.getApplicationContext() == this.applicationContext && camelContext.getStatus().isStopped()) {
            LOG.debug("Post-processing CamelContext bean: {}", (Object)camelContext.getName());
            RoutesConfigurer configurer = new RoutesConfigurer(this.springBootRoutesCollector);
            configurer.configureRoutes(camelContext, (DefaultConfigurationProperties)this.configurationProperties);
            for (CamelContextConfiguration camelContextConfiguration : this.camelContextConfigurations) {
                LOG.debug("CamelContextConfiguration found. Invoking beforeApplicationStart: {}", (Object)camelContextConfiguration);
                camelContextConfiguration.beforeApplicationStart(camelContext);
            }
            try {
                if (this.configurationProperties.isMainRunController()) {
                    final CamelMainRunController controller = new CamelMainRunController(this.applicationContext, camelContext);
                    if (this.configurationProperties.getDurationMaxMessages() > 0 || this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                        if (this.configurationProperties.getDurationMaxMessages() > 0) {
                            LOG.info("CamelSpringBoot will terminate after processing {} messages", (Object)this.configurationProperties.getDurationMaxMessages());
                        }
                        if (this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                            LOG.info("CamelSpringBoot will terminate after being idle for more {} seconds", (Object)this.configurationProperties.getDurationMaxIdleSeconds());
                        }
                        MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.configurationProperties.getDurationMaxMessages(), (long)this.configurationProperties.getDurationMaxIdleSeconds(), controller.getCompleted(), controller.getLatch(), true);
                        ServiceHelper.startService((Object)notifier);
                        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                    }
                    if (this.configurationProperties.getDurationMaxSeconds() > 0) {
                        LOG.info("CamelSpringBoot will terminate after {} seconds", (Object)this.configurationProperties.getDurationMaxSeconds());
                        this.terminateMainControllerAfter(camelContext, this.configurationProperties.getDurationMaxSeconds(), controller.getCompleted(), controller.getLatch());
                    }
                    camelContext.addStartupListener(new StartupListener(){

                        public void onCamelContextStarted(CamelContext context, boolean alreadyStarted) throws Exception {
                            if (!alreadyStarted) {
                                LOG.info("Starting CamelMainRunController to ensure the main thread keeps running");
                                controller.start();
                            }
                        }
                    });
                } else if (this.applicationContext instanceof ConfigurableApplicationContext) {
                    ConfigurableApplicationContext cac = (ConfigurableApplicationContext)this.applicationContext;
                    if (this.configurationProperties.getDurationMaxSeconds() > 0) {
                        LOG.info("CamelSpringBoot will terminate after {} seconds", (Object)this.configurationProperties.getDurationMaxSeconds());
                        this.terminateApplicationContext(cac, camelContext, this.configurationProperties.getDurationMaxSeconds());
                    }
                    if (this.configurationProperties.getDurationMaxMessages() > 0 || this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                        if (this.configurationProperties.getDurationMaxMessages() > 0) {
                            LOG.info("CamelSpringBoot will terminate after processing {} messages", (Object)this.configurationProperties.getDurationMaxMessages());
                        }
                        if (this.configurationProperties.getDurationMaxIdleSeconds() > 0) {
                            LOG.info("CamelSpringBoot will terminate after being idle for more {} seconds", (Object)this.configurationProperties.getDurationMaxIdleSeconds());
                        }
                        AtomicBoolean completed = new AtomicBoolean();
                        CountDownLatch latch = new CountDownLatch(1);
                        MainDurationEventNotifier notifier = new MainDurationEventNotifier(camelContext, this.configurationProperties.getDurationMaxMessages(), (long)this.configurationProperties.getDurationMaxIdleSeconds(), completed, latch, false);
                        ServiceHelper.startService((Object)notifier);
                        camelContext.getManagementStrategy().addEventNotifier((EventNotifier)notifier);
                        this.terminateApplicationContext(cac, camelContext, latch);
                    }
                }
                if (this.camelContextConfigurations.isEmpty()) return;
                camelContext.getManagementStrategy().addEventNotifier((EventNotifier)new EventNotifierSupport(){

                    public void notify(CamelEvent eventObject) throws Exception {
                        for (CamelContextConfiguration camelContextConfiguration : CamelSpringBootApplicationListener.this.camelContextConfigurations) {
                            LOG.debug("CamelContextConfiguration found. Invoking afterApplicationStart: {}", (Object)camelContextConfiguration);
                            try {
                                camelContextConfiguration.afterApplicationStart(camelContext);
                            }
                            catch (Exception e) {
                                LOG.warn("Error during calling afterApplicationStart due " + e.getMessage() + ". This exception is ignored", (Throwable)e);
                            }
                        }
                    }

                    public boolean isEnabled(CamelEvent eventObject) {
                        return eventObject.getType() == CamelEvent.Type.CamelContextStarted;
                    }
                });
                return;
            }
            catch (Exception e) {
                throw new CamelSpringBootInitializationException(e);
            }
        } else {
            LOG.debug("Camel already started, not adding routes.");
        }
    }

    public int getOrder() {
        return 0x7FFFFFFD;
    }

    private void terminateMainControllerAfter(CamelContext camelContext, int seconds, AtomicBoolean completed, CountDownLatch latch) {
        ScheduledExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "CamelSpringBootTerminateTask");
        Runnable task = () -> {
            LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
            try {
                camelContext.stop();
            }
            catch (Throwable e) {
                LOG.warn("Error during stopping CamelContext", e);
            }
            finally {
                completed.set(true);
                latch.countDown();
            }
        };
        executorService.schedule(task, (long)seconds, TimeUnit.SECONDS);
    }

    private void terminateApplicationContext(ConfigurableApplicationContext applicationContext, CamelContext camelContext, int seconds) {
        ScheduledExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadScheduledExecutor((Object)this, "CamelSpringBootTerminateTask");
        Runnable task = () -> {
            LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
            new Thread(() -> ((ConfigurableApplicationContext)applicationContext).close()).start();
        };
        executorService.schedule(task, (long)seconds, TimeUnit.SECONDS);
    }

    private void terminateApplicationContext(ConfigurableApplicationContext applicationContext, CamelContext camelContext, CountDownLatch latch) {
        ExecutorService executorService = camelContext.getExecutorServiceManager().newSingleThreadExecutor((Object)this, "CamelSpringBootTerminateTask");
        Runnable task = () -> {
            try {
                latch.await();
                LOG.info("CamelSpringBoot triggering shutdown of the JVM.");
                new Thread(() -> ((ConfigurableApplicationContext)applicationContext).close()).start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        };
        executorService.submit(task);
    }
}

