/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet.springboot;

import jakarta.servlet.Servlet;
import org.apache.camel.CamelContext;
import org.apache.camel.component.servlet.CamelHttpTransportServlet;
import org.apache.camel.component.servlet.ServletComponent;
import org.apache.camel.component.servlet.springboot.ServletMappingConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"camel.servlet.mapping.enabled"}, matchIfMissing=true)
@ConditionalOnBean(type={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@AutoConfigureAfter(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={ServletMappingConfiguration.class, MultipartProperties.class})
public class ServletMappingAutoConfiguration {
    @Bean
    ServletRegistrationBean camelServletRegistrationBean(ServletMappingConfiguration config, MultipartProperties multipartProperties) {
        ServletRegistrationBean mapping = new ServletRegistrationBean();
        mapping.setServlet((Servlet)new CamelHttpTransportServlet());
        mapping.addUrlMappings(new String[]{config.getContextPath()});
        mapping.setName(config.getServletName());
        mapping.setLoadOnStartup(1);
        if (multipartProperties != null && multipartProperties.getEnabled()) {
            mapping.setMultipartConfig(multipartProperties.createMultipartConfig());
        }
        return mapping;
    }

    @Lazy
    @Bean(name={"servlet-component"})
    @ConditionalOnMissingBean(value={ServletComponent.class})
    public ServletComponent configureServletComponent(CamelContext camelContext) throws Exception {
        ServletComponent component = new ServletComponent();
        component.setCamelContext(camelContext);
        return component;
    }
}

