/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.springboot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class SalesforceComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, SalesforceHttpClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ObjectMapper.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ReportMetadata.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SalesforceEndpointConfig.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KeyStoreParameters.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SalesforceLoginConfig.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SSLContextParameters.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.salesforce.SalesforceHttpClient": {
                return this.applicationContext.getBean(ref, SalesforceHttpClient.class);
            }
            case "com.fasterxml.jackson.databind.ObjectMapper": {
                return this.applicationContext.getBean(ref, ObjectMapper.class);
            }
            case "org.apache.camel.component.salesforce.api.dto.analytics.reports.ReportMetadata": {
                return this.applicationContext.getBean(ref, ReportMetadata.class);
            }
            case "org.apache.camel.component.salesforce.SalesforceEndpointConfig": {
                return this.applicationContext.getBean(ref, SalesforceEndpointConfig.class);
            }
            case "org.apache.camel.support.jsse.KeyStoreParameters": {
                return this.applicationContext.getBean(ref, KeyStoreParameters.class);
            }
            case "org.apache.camel.component.salesforce.SalesforceLoginConfig": {
                return this.applicationContext.getBean(ref, SalesforceLoginConfig.class);
            }
            case "org.apache.camel.support.jsse.SSLContextParameters": {
                return this.applicationContext.getBean(ref, SSLContextParameters.class);
            }
        }
        return null;
    }
}

