/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.platform.http.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.platform.http.PlatformHttpComponent;
import org.apache.camel.component.platform.http.spi.PlatformHttpEngine;
import org.apache.camel.component.platform.http.springboot.CamelRequestHandlerMapping;
import org.apache.camel.component.platform.http.springboot.SpringBootPlatformHttpEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(name={"org.apache.camel.component.servlet.springboot.PlatformHttpComponentAutoConfiguration", "org.apache.camel.component.servlet.springboot.PlatformHttpComponentConverter"})
public class SpringBootPlatformHttpAutoConfiguration {
    @Autowired
    CamelContext camelContext;

    @Bean(name={"platform-http-engine"})
    @ConditionalOnMissingBean(value={PlatformHttpEngine.class})
    public PlatformHttpEngine springBootPlatformHttpEngine() {
        return new SpringBootPlatformHttpEngine();
    }

    @Bean
    @DependsOn(value={"configurePlatformHttpComponent"})
    public CamelRequestHandlerMapping platformHttpEngineRequestMapping(PlatformHttpEngine engine) {
        PlatformHttpComponent component = (PlatformHttpComponent)this.camelContext.getComponent("platform-http", PlatformHttpComponent.class);
        CamelRequestHandlerMapping answer = new CamelRequestHandlerMapping(component, engine);
        return answer;
    }
}

