/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt.springboot;

import java.util.Map;
import java.util.Properties;
import org.apache.camel.component.jasypt.springboot.EncryptablePropertySourcesPlaceholderConfigurer;
import org.apache.camel.component.jasypt.springboot.JasyptEncryptedPropertiesAutoconfiguration;
import org.apache.camel.component.jasypt.springboot.JasyptEncryptedPropertiesConfiguration;
import org.apache.camel.component.properties.PropertiesParser;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;

public class SpringBootJasyptPropertiesParser
implements ApplicationListener<ApplicationEnvironmentPreparedEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootJasyptPropertiesParser.class);

    public void onApplicationEvent(ApplicationEnvironmentPreparedEvent event) {
        ConfigurableEnvironment environment = event.getEnvironment();
        JasyptEncryptedPropertiesAutoconfiguration jasyptEncryptedPropertiesAutoconfiguration = new JasyptEncryptedPropertiesAutoconfiguration();
        JasyptEncryptedPropertiesConfiguration jasyptEncryptedPropertiesConfiguration = jasyptEncryptedPropertiesAutoconfiguration.JasyptEncryptedPropertiesAutoconfiguration(event.getEnvironment());
        if (jasyptEncryptedPropertiesConfiguration != null && jasyptEncryptedPropertiesConfiguration.isEarlyDecryptionEnabled()) {
            String password = jasyptEncryptedPropertiesConfiguration.getPassword();
            if (password.startsWith("sysenv:")) {
                password = System.getenv(StringHelper.after((String)password, (String)"sysenv:"));
            }
            if (ObjectHelper.isNotEmpty((String)password) && password.startsWith("sys:")) {
                password = System.getProperty(StringHelper.after((String)password, (String)"sys:"));
            }
            jasyptEncryptedPropertiesConfiguration.setPassword(password);
            EnvironmentStringPBEConfig environmentStringPBEConfig = jasyptEncryptedPropertiesAutoconfiguration.environmentVariablesConfiguration(jasyptEncryptedPropertiesConfiguration);
            StringEncryptor stringEncryptor = jasyptEncryptedPropertiesAutoconfiguration.stringEncryptor(environmentStringPBEConfig);
            EncryptablePropertySourcesPlaceholderConfigurer encryptablePropertySourcesPlaceholderConfigurer = jasyptEncryptedPropertiesAutoconfiguration.propertyConfigurer(stringEncryptor);
            PropertiesParser propertiesParser = jasyptEncryptedPropertiesAutoconfiguration.encryptedPropertiesParser((PropertyResolver)environment, stringEncryptor, (Environment)environment);
            Properties props = new Properties();
            for (PropertySource mutablePropertySources : event.getEnvironment().getPropertySources()) {
                if (!(mutablePropertySources instanceof MapPropertySource)) continue;
                MapPropertySource mapPropertySource = (MapPropertySource)mutablePropertySources;
                ((Map)mapPropertySource.getSource()).forEach((key, value) -> {
                    String stringValue;
                    OriginTrackedValue originTrackedValue;
                    Object patt0$temp;
                    if (value instanceof OriginTrackedValue && (patt0$temp = (originTrackedValue = (OriginTrackedValue)value).getValue()) instanceof String && (stringValue = (String)patt0$temp).startsWith("ENC(") && stringValue.endsWith(")")) {
                        LOG.debug("decrypting and overriding property {}", key);
                        try {
                            props.put(key, propertiesParser.parseProperty(key.toString(), stringValue, null));
                        }
                        catch (Exception e) {
                            LOG.debug("failed to parse property {}", key, (Object)e);
                        }
                    }
                });
            }
            environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("overridden-camel-jasypt-properties", props));
        }
    }
}

