/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt.springboot;

import org.apache.camel.component.properties.PropertiesLookup;
import org.apache.camel.spring.boot.SpringPropertiesParser;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;

public class JasyptSpringEncryptedPropertiesParser
extends SpringPropertiesParser {
    private PropertyResolver propertyResolver;
    private StringEncryptor stringEncryptor;

    @Autowired
    public JasyptSpringEncryptedPropertiesParser(PropertyResolver propertyResolver, StringEncryptor stringEncryptor, Environment env) {
        super(env);
        this.propertyResolver = propertyResolver;
        this.stringEncryptor = stringEncryptor;
    }

    public String parseProperty(String key, String value, PropertiesLookup properties) {
        String originalValue = this.propertyResolver.getProperty(key);
        return PropertyValueEncryptionUtils.isEncryptedValue((String)originalValue) ? PropertyValueEncryptionUtils.decrypt((String)originalValue, (StringEncryptor)this.stringEncryptor) : originalValue;
    }
}

