/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt.springboot;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.camel.component.jasypt.springboot.JasyptEncryptedPropertiesConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.jasypt.encryption.pbe.config.EnvironmentStringPBEConfig;
import org.jasypt.exceptions.EncryptionInitializationException;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.NoIvGenerator;
import org.jasypt.iv.RandomIvGenerator;

public class JasyptEncryptedPropertiesUtils {
    private static final String SYSTEM_ENVIRONMENT_PREFIX = "sysenv:";
    private static final String SYSTEM_PROPERTIES_PREFIX = "sys:";
    static final Set<String> ALGORITHMS_THAT_REQUIRE_IV = new HashSet<String>(Arrays.asList("PBEWITHHMACSHA1ANDAES_128", "PBEWITHHMACSHA1ANDAES_256", "PBEWITHHMACSHA224ANDAES_128", "PBEWITHHMACSHA224ANDAES_256", "PBEWITHHMACSHA256ANDAES_128", "PBEWITHHMACSHA256ANDAES_256", "PBEWITHHMACSHA384ANDAES_128", "PBEWITHHMACSHA384ANDAES_256", "PBEWITHHMACSHA512ANDAES_128", "PBEWITHHMACSHA512ANDAES_256"));

    static boolean isIVNeeded(String algorithm) {
        if (JasyptEncryptedPropertiesUtils.isNotBlank(algorithm)) {
            return ALGORITHMS_THAT_REQUIRE_IV.contains(algorithm.toUpperCase());
        }
        return false;
    }

    static boolean isBlank(CharSequence cs) {
        int strLen;
        int n = strLen = cs == null ? 0 : cs.length();
        if (strLen == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean isNotBlank(CharSequence cs) {
        return !JasyptEncryptedPropertiesUtils.isBlank(cs);
    }

    static void parsePassword(EnvironmentStringPBEConfig environmentStringPBEConfig, JasyptEncryptedPropertiesConfiguration configuration) {
        String passwordReference = configuration.getPassword();
        if (ObjectHelper.isNotEmpty((String)passwordReference) && passwordReference.startsWith(SYSTEM_ENVIRONMENT_PREFIX)) {
            environmentStringPBEConfig.setPasswordEnvName(StringHelper.after((String)passwordReference, (String)SYSTEM_ENVIRONMENT_PREFIX));
            return;
        }
        if (ObjectHelper.isNotEmpty((String)passwordReference) && passwordReference.startsWith(SYSTEM_PROPERTIES_PREFIX)) {
            environmentStringPBEConfig.setPasswordSysPropertyName(StringHelper.after((String)passwordReference, (String)SYSTEM_PROPERTIES_PREFIX));
            return;
        }
        environmentStringPBEConfig.setPassword(passwordReference);
    }

    static IvGenerator getIVGenerator(JasyptEncryptedPropertiesConfiguration configuration) {
        String ivGeneratorClassName = configuration.getIvGeneratorClassName();
        String algorithm = configuration.getAlgorithm();
        if (JasyptEncryptedPropertiesUtils.isBlank(ivGeneratorClassName)) {
            if (JasyptEncryptedPropertiesUtils.isIVNeeded(algorithm)) {
                return configuration.getRandomIvGeneratorAlgorithm() != null ? new RandomIvGenerator(configuration.getRandomIvGeneratorAlgorithm()) : new RandomIvGenerator();
            }
            return new NoIvGenerator();
        }
        IvGenerator ivGenerator = (IvGenerator)JasyptEncryptedPropertiesUtils.loadClass(ivGeneratorClassName);
        return ivGenerator;
    }

    static <T> T loadClass(String className) {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (T)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new EncryptionInitializationException((Throwable)e);
        }
    }
}

