/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt.springboot;

import org.apache.camel.component.properties.DefaultPropertiesParser;
import org.apache.camel.component.properties.PropertiesLookup;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.PropertyResolver;

public class JasyptSpringEncryptedPropertiesParser
extends DefaultPropertiesParser {
    private PropertyResolver propertyResolver;
    private StringEncryptor stringEncryptor;

    @Autowired
    public JasyptSpringEncryptedPropertiesParser(PropertyResolver propertyResolver, StringEncryptor stringEncryptor) {
        this.propertyResolver = propertyResolver;
        this.stringEncryptor = stringEncryptor;
    }

    public String parseProperty(String key, String value, PropertiesLookup properties) {
        String originalValue = this.propertyResolver.getProperty(key);
        return PropertyValueEncryptionUtils.isEncryptedValue((String)originalValue) ? PropertyValueEncryptionUtils.decrypt((String)originalValue, (StringEncryptor)this.stringEncryptor) : originalValue;
    }
}

