/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jasypt.springboot;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.util.StringValueResolver;

public class EncryptablePropertySourcesPlaceholderConfigurer
extends PropertySourcesPlaceholderConfigurer {
    private StringEncryptor stringEncryptor;

    @Autowired
    public EncryptablePropertySourcesPlaceholderConfigurer(StringEncryptor stringEncryptor) {
        this.stringEncryptor = stringEncryptor;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactory, ConfigurablePropertyResolver propertyResolver) throws BeansException {
        propertyResolver.setPlaceholderPrefix(this.placeholderPrefix);
        propertyResolver.setPlaceholderSuffix(this.placeholderSuffix);
        propertyResolver.setValueSeparator(this.valueSeparator);
        StringValueResolver valueResolver = strVal -> {
            String resolved;
            String string = resolved = this.ignoreUnresolvablePlaceholders ? propertyResolver.resolvePlaceholders(strVal) : propertyResolver.resolveRequiredPlaceholders(strVal);
            if (this.trimValues) {
                resolved = resolved.trim();
            }
            if (PropertyValueEncryptionUtils.isEncryptedValue((String)resolved)) {
                resolved = PropertyValueEncryptionUtils.decrypt((String)resolved, (StringEncryptor)this.stringEncryptor);
            }
            return resolved.equals(this.nullValue) ? null : resolved;
        };
        this.doProcessProperties(beanFactory, valueResolver);
    }
}

