/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.set.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.hazelcast.set.HazelcastSetComponent;
import org.apache.camel.component.hazelcast.set.springboot.HazelcastSetComponentConfiguration;
import org.apache.camel.component.hazelcast.set.springboot.HazelcastSetComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, HazelcastSetComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.hazelcast-set"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, HazelcastSetComponentConverter.class})
public class HazelcastSetComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private HazelcastSetComponentConfiguration configuration;

    public HazelcastSetComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureHazelcastSetComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)HazelcastSetComponentAutoConfiguration.this.camelContext, (Object)((Object)HazelcastSetComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)HazelcastSetComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.hazelcast-set.customizer"}) && target instanceof HazelcastSetComponent;
            }
        };
    }
}

