/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.debug;

import org.apache.camel.CamelContext;
import org.apache.camel.impl.debugger.DebuggerJmxConnectorService;
import org.apache.camel.impl.debugger.DefaultBacklogDebugger;
import org.apache.camel.spi.BacklogDebugger;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.CamelSpringBootApplicationListener;
import org.apache.camel.spring.boot.debug.CamelDebugConfigurationProperties;
import org.apache.camel.support.LifecycleStrategySupport;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelDebugConfigurationProperties.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@AutoConfigureBefore(value={CamelSpringBootApplicationListener.class})
public class CamelDebugAutoConfiguration {
    @Bean
    public BacklogDebugger backlogDebugger(CamelContext camelContext, final CamelDebugConfigurationProperties config) throws Exception {
        camelContext.setDebugging(Boolean.valueOf(config.isEnabled()));
        camelContext.setDebugStandby(config.isStandby());
        if (config.isEnabled() || config.isStandby()) {
            camelContext.setSourceLocationEnabled(Boolean.valueOf(true));
            camelContext.setMessageHistory(Boolean.valueOf(true));
        }
        final BacklogDebugger debugger = DefaultBacklogDebugger.createDebugger((CamelContext)camelContext);
        debugger.setStandby(config.isStandby());
        debugger.setInitialBreakpoints(config.getBreakpoints());
        debugger.setSingleStepIncludeStartEnd(config.isSingleStepIncludeStartEnd());
        debugger.setBodyMaxChars(config.getBodyMaxChars());
        debugger.setBodyIncludeStreams(config.isBodyIncludeStreams());
        debugger.setBodyIncludeFiles(config.isBodyIncludeFiles());
        debugger.setIncludeExchangeProperties(config.isIncludeExchangeProperties());
        debugger.setIncludeExchangeVariables(config.isIncludeExchangeVariables());
        debugger.setIncludeException(config.isIncludeException());
        debugger.setLoggingLevel(config.getLoggingLevel().name());
        if (config.isWaitForAttach()) {
            debugger.setSuspendMode(config.isWaitForAttach());
        }
        debugger.setFallbackTimeout(config.getFallbackTimeout());
        if (config.isJmxConnectorEnabled()) {
            DebuggerJmxConnectorService connector = new DebuggerJmxConnectorService();
            connector.setCreateConnector(true);
            connector.setRegistryPort(config.getJmxConnectorPort());
            camelContext.addService((Object)connector);
        }
        camelContext.addLifecycleStrategy((LifecycleStrategy)new LifecycleStrategySupport(){

            public void onContextStarted(CamelContext context) {
                if (config.isEnabled() && !debugger.isStandby()) {
                    debugger.enableDebugger();
                }
            }

            public void onContextStopping(CamelContext context) {
                if (debugger.isEnabled()) {
                    debugger.disableDebugger();
                }
            }
        });
        camelContext.addService((Object)debugger);
        return debugger;
    }
}

