/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.springboot.cli.connector;

import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Manifest;
import org.apache.camel.spi.CliConnectorFactory;
import org.apache.camel.springboot.cli.connector.CliConnectorConfiguration;
import org.apache.camel.springboot.cli.connector.SpringCliConnectorFactory;
import org.springframework.boot.SpringBootVersion;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.AbstractApplicationContext;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"camel.cli.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(name={"org.apache.camel.spring.boot.CamelAutoConfiguration"})
@EnableConfigurationProperties(value={CliConnectorConfiguration.class})
public class CliConnectorAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={CliConnectorFactory.class})
    public CliConnectorFactory cliConnectorFactory(AbstractApplicationContext applicationContext, CliConnectorConfiguration config) {
        SpringCliConnectorFactory answer = new SpringCliConnectorFactory(applicationContext);
        answer.setEnabled(config.getEnabled());
        answer.setRuntime("Spring Boot");
        answer.setRuntimeVersion(SpringBootVersion.getVersion());
        try {
            Enumeration<URL> en = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (en.hasMoreElements()) {
                URL u = en.nextElement();
                InputStream is = u.openStream();
                try {
                    Manifest manifest = new Manifest(is);
                    String sc = manifest.getMainAttributes().getValue("Start-Class");
                    if (sc == null) continue;
                    answer.setRuntimeStartClass(sc);
                    break;
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return answer;
    }
}

