/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean.validator.springboot;

import jakarta.validation.ConstraintValidatorFactory;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.TraversableResolver;
import jakarta.validation.ValidationProviderResolver;
import jakarta.validation.ValidatorFactory;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class BeanValidatorComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConstraintValidatorFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageInterpolator.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TraversableResolver.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ValidationProviderResolver.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ValidatorFactory.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "jakarta.validation.ConstraintValidatorFactory": {
                return this.applicationContext.getBean(ref, ConstraintValidatorFactory.class);
            }
            case "jakarta.validation.MessageInterpolator": {
                return this.applicationContext.getBean(ref, MessageInterpolator.class);
            }
            case "jakarta.validation.TraversableResolver": {
                return this.applicationContext.getBean(ref, TraversableResolver.class);
            }
            case "jakarta.validation.ValidationProviderResolver": {
                return this.applicationContext.getBean(ref, ValidationProviderResolver.class);
            }
            case "jakarta.validation.ValidatorFactory": {
                return this.applicationContext.getBean(ref, ValidatorFactory.class);
            }
        }
        return null;
    }
}

