/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.amqp.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import org.apache.camel.component.jms.JmsConfiguration;
import org.apache.camel.component.jms.MessageCreatedStrategy;
import org.apache.camel.component.jms.MessageListenerContainerFactory;
import org.apache.camel.component.jms.QueueBrowseStrategy;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.support.converter.MessageConverter;
import org.springframework.jms.support.destination.DestinationResolver;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.ErrorHandler;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class AMQPComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConnectionFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TaskExecutor.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, JmsConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, DestinationResolver.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ErrorHandler.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ExceptionListener.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageConverter.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageCreatedStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageListenerContainerFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, QueueBrowseStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HeaderFilterStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PlatformTransactionManager.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.jms.ConnectionFactory": {
                return this.applicationContext.getBean(ref, ConnectionFactory.class);
            }
            case "org.springframework.core.task.TaskExecutor": {
                return this.applicationContext.getBean(ref, TaskExecutor.class);
            }
            case "org.apache.camel.component.jms.JmsConfiguration": {
                return this.applicationContext.getBean(ref, JmsConfiguration.class);
            }
            case "org.springframework.jms.support.destination.DestinationResolver": {
                return this.applicationContext.getBean(ref, DestinationResolver.class);
            }
            case "org.springframework.util.ErrorHandler": {
                return this.applicationContext.getBean(ref, ErrorHandler.class);
            }
            case "javax.jms.ExceptionListener": {
                return this.applicationContext.getBean(ref, ExceptionListener.class);
            }
            case "org.springframework.jms.support.converter.MessageConverter": {
                return this.applicationContext.getBean(ref, MessageConverter.class);
            }
            case "org.apache.camel.component.jms.MessageCreatedStrategy": {
                return this.applicationContext.getBean(ref, MessageCreatedStrategy.class);
            }
            case "org.apache.camel.component.jms.MessageListenerContainerFactory": {
                return this.applicationContext.getBean(ref, MessageListenerContainerFactory.class);
            }
            case "org.apache.camel.component.jms.QueueBrowseStrategy": {
                return this.applicationContext.getBean(ref, QueueBrowseStrategy.class);
            }
            case "org.apache.camel.spi.HeaderFilterStrategy": {
                return this.applicationContext.getBean(ref, HeaderFilterStrategy.class);
            }
            case "org.springframework.transaction.PlatformTransactionManager": {
                return this.applicationContext.getBean(ref, PlatformTransactionManager.class);
            }
        }
        return null;
    }
}

