/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.support.mongodb.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.mongodb.deployment.MongoClientBuildItem;
import io.quarkus.mongodb.runtime.MongoClientBeanUtil;
import java.util.List;
import org.apache.camel.quarkus.core.deployment.spi.CamelRuntimeBeanBuildItem;

class SupportMongoDBProcessor {
    SupportMongoDBProcessor() {
    }

    @BuildStep
    void registerCamelMongoClientProducers(List<MongoClientBuildItem> mongoClients, BuildProducer<CamelRuntimeBeanBuildItem> runtimeBeans) {
        for (MongoClientBuildItem mongoClient : mongoClients) {
            String clientName = this.getMongoClientName(mongoClient.getName());
            runtimeBeans.produce((BuildItem)new CamelRuntimeBeanBuildItem(clientName, "com.mongodb.client.MongoClient", mongoClient.getClient()));
        }
    }

    private String getMongoClientName(String clientName) {
        return MongoClientBeanUtil.isDefault((String)clientName) ? "camelMongoClient" : clientName;
    }
}

