/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.mongodb.gridfs.it;

import com.mongodb.MongoGridFSException;
import com.mongodb.client.MongoClient;
import io.quarkus.mongodb.MongoClientName;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;

@Path(value="/mongodb-gridfs")
public class MongodbGridfsResource {
    static final String DEFAULT_MONGO_CLIENT_NAME = "camelMongoClient";
    static final String NAMED_MONGO_CLIENT_NAME = "myMongoClient";
    @Inject
    @MongoClientName(value="myMongoClient")
    MongoClient namedMongoClient;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/upload/{fileName}")
    @POST
    @Produces(value={"text/plain"})
    public Response uploadFile(@PathParam(value="fileName") String fileName, String content, @HeaderParam(value="mongoClientName") String mongoClientName) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("CamelFileName", fileName);
        headers.put("Content-Type", "text/plain");
        Exchange result = this.producerTemplate.request(String.format("mongodb-gridfs:%s?database=test&operation=create", mongoClientName), exchange -> {
            exchange.getMessage().setHeaders(headers);
            exchange.getMessage().setBody((Object)content);
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).entity(result.getMessage().getHeader("gridfs.objectid")).build();
    }

    @Path(value="/get/{fileName}")
    @GET
    @Produces(value={"text/plain"})
    public Response retrieveFile(@PathParam(value="fileName") String fileName, @HeaderParam(value="mongoClientName") String mongoClientName) {
        String result;
        block2: {
            result = null;
            try {
                result = (String)this.producerTemplate.requestBodyAndHeader(String.format("mongodb-gridfs:%s?database=test&operation=findOne", mongoClientName), null, "CamelFileName", (Object)fileName, String.class);
            }
            catch (Exception e) {
                if (!(e.getCause() instanceof MongoGridFSException)) break block2;
                return Response.status((int)404).build();
            }
        }
        return Response.ok().entity(result).build();
    }

    @Path(value="/delete/{fileName}")
    @DELETE
    public Response deleteFile(@PathParam(value="fileName") String fileName, @HeaderParam(value="mongoClientName") String mongoClientName) {
        this.producerTemplate.requestBodyAndHeader(String.format("mongodb-gridfs:camelMongoClient?database=test&operation=remove", mongoClientName), null, "CamelFileName", (Object)fileName);
        return Response.noContent().build();
    }
}

