/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.quarkus.QuarkusRuntimeProvider;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.k.catalog.model.CamelArtifact;
import org.apache.camel.k.catalog.model.CamelCapability;
import org.apache.camel.k.catalog.model.CamelLoader;
import org.apache.camel.k.catalog.model.CamelScheme;
import org.apache.camel.k.catalog.model.CamelScopedArtifact;
import org.apache.camel.k.catalog.model.CatalogComponentDefinition;
import org.apache.camel.k.catalog.model.CatalogDataFormatDefinition;
import org.apache.camel.k.catalog.model.CatalogDefinition;
import org.apache.camel.k.catalog.model.CatalogLanguageDefinition;
import org.apache.camel.k.catalog.model.CatalogSupport;
import org.apache.camel.k.catalog.model.k8s.ObjectMeta;
import org.apache.camel.k.catalog.model.k8s.crd.CamelCatalog;
import org.apache.camel.k.catalog.model.k8s.crd.CamelCatalogSpec;
import org.apache.camel.k.catalog.model.k8s.crd.ImmutableCamelCatalog;
import org.apache.camel.k.catalog.model.k8s.crd.RuntimeSpec;
import org.apache.camel.k.tooling.maven.GenerateSupport;
import org.apache.camel.k.tooling.maven.support.MavenSupport;
import org.apache.camel.quarkus.core.FastCamelContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="generate-catalog", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateCatalogMojo
extends AbstractMojo {
    private static final List<String> KNOWN_HTTP_URIS = Arrays.asList("ahc", "ahc-ws", "atmosphere-websocket", "cxf", "cxfrs", "grpc", "jetty", "netty-http", "platform-http", "rest", "restlet", "servlet", "spark-rest", "spring-ws", "undertow", "webhook", "websocket");
    private static final List<String> KNOWN_PASSIVE_URIS = Arrays.asList("bean", "binding", "browse", "class", "controlbus", "dataformat", "dataset", "direct", "direct-vm", "language", "log", "mock", "ref", "seda", "stub", "test", "validator", "vm");
    @Parameter(property="catalog.path", defaultValue="${project.build.directory}")
    private String outputPath;
    @Parameter(property="catalog.file", defaultValue="camel-catalog-${runtime.version}.yaml")
    private String outputFile;
    @Parameter(property="components.exclusion.list")
    private Set<String> componentsExclusionList;
    @Parameter(property="dataformats.exclusion.list")
    private Set<String> dataformatsExclusionList;
    @Parameter(property="languages.exclusion.list")
    private Set<String> languagesExclusionList;
    @Parameter(property="dsls.exclusion.list")
    private Set<String> dslsExclusionList;
    @Parameter(property="capabilities.exclusion.list")
    private Set<String> capabilitiesExclusionList;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path output = Paths.get(this.outputPath, this.outputFile);
        try {
            if (Files.notExists(output.getParent(), new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(output, new LinkOption[0])) {
                Files.delete(output);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating camel catalog", (Exception)e);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        catalog.setRuntimeProvider((RuntimeProvider)new QuarkusRuntimeProvider());
        String runtimeVersion = MavenSupport.getVersion(((Object)((Object)this)).getClass(), "/META-INF/maven/org.apache.camel.k/camel-k-maven-plugin/pom.properties");
        String catalogName = String.format("camel-catalog-%s", runtimeVersion.toLowerCase(Locale.US));
        try {
            CamelCatalogSpec.Builder catalogSpec = new CamelCatalogSpec.Builder();
            RuntimeSpec.Builder runtimeSpec = new RuntimeSpec.Builder().version(runtimeVersion).provider("quarkus");
            MavenSupport.getVersion(AbstractCamelContext.class, "org.apache.camel", "camel-base", version -> runtimeSpec.putMetadata("camel.version", version));
            MavenSupport.getVersion(FastCamelContext.class, "io.quarkus", "quarkus-core", version -> runtimeSpec.putMetadata("quarkus.version", version));
            MavenSupport.getVersion(QuarkusRuntimeProvider.class, "org.apache.camel.quarkus", "camel-quarkus-catalog", version -> runtimeSpec.putMetadata("camel-quarkus.version", version));
            runtimeSpec.applicationClass("io.quarkus.bootstrap.runner.QuarkusEntryPoint");
            runtimeSpec.addDependency("org.apache.camel.k", "camel-k-runtime");
            runtimeSpec.addDependency("io.quarkus", "quarkus-logging-json");
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("cron")) {
                runtimeSpec.putCapability("cron", CamelCapability.forArtifact((String)"org.apache.camel.k", (String)"camel-k-cron"));
                catalogSpec.putArtifact((CamelArtifact)new CamelArtifact.Builder().groupId("org.apache.camel.k").artifactId("camel-k-cron").build());
            }
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("health")) {
                runtimeSpec.putCapability("health", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-microprofile-health"));
            }
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("platform-http")) {
                runtimeSpec.putCapability("platform-http", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-platform-http"));
            }
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("rest")) {
                runtimeSpec.putCapability("rest", (CamelCapability)new CamelCapability.Builder().addDependency("org.apache.camel.quarkus", "camel-quarkus-rest").addDependency("org.apache.camel.quarkus", "camel-quarkus-platform-http").build());
            }
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("circuit-breaker")) {
                runtimeSpec.putCapability("circuit-breaker", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-microprofile-fault-tolerance"));
            }
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("tracing")) {
                runtimeSpec.putCapability("tracing", CamelCapability.forArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-opentracing"));
            }
            if (this.capabilitiesExclusionList != null && !this.capabilitiesExclusionList.contains("master")) {
                runtimeSpec.putCapability("master", CamelCapability.forArtifact((String)"org.apache.camel.k", (String)"camel-k-master"));
                catalogSpec.putArtifact((CamelArtifact)new CamelArtifact.Builder().groupId("org.apache.camel.k").artifactId("camel-k-master").build());
            }
            catalogSpec.runtime((RuntimeSpec)runtimeSpec.build());
            this.process((CamelCatalog)catalog, catalogSpec);
            ObjectMeta.Builder metadata = new ObjectMeta.Builder().name(catalogName).putLabels("app", "camel-k").putLabels("camel.apache.org/catalog.version", catalog.getCatalogVersion()).putLabels("camel.apache.org/catalog.loader.version", catalog.getLoadedVersion()).putLabels("camel.apache.org/runtime.version", runtimeVersion);
            ImmutableCamelCatalog cr = new CamelCatalog.Builder().metadata((ObjectMeta)metadata.build()).spec((CamelCatalogSpec)catalogSpec.build()).build();
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
                YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false).configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
                writer.write(GenerateSupport.getResourceAsString("/catalog-license.txt"));
                this.getLog().info((CharSequence)("Writing catalog file to: " + output));
                ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
                mapper.registerModule((Module)new Jdk8Module());
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                mapper.writeValue((Writer)writer, (Object)cr);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating catalog", (Exception)e);
        }
    }

    public void process(CamelCatalog catalog, CamelCatalogSpec.Builder specBuilder) {
        TreeMap<String, CamelArtifact> artifacts = new TreeMap<String, CamelArtifact>();
        this.processComponents(catalog, artifacts);
        this.processLanguages(catalog, artifacts);
        this.processDataFormats(catalog, artifacts);
        this.processLoaders(specBuilder);
        specBuilder.putAllArtifacts(artifacts);
        specBuilder.putArtifact((CamelArtifact)new CamelArtifact.Builder().groupId("org.apache.camel.k").artifactId("camel-k-knative").addScheme((CamelScheme)new CamelScheme.Builder().id("knative").http(true).consumer((CamelScopedArtifact)new CamelScopedArtifact.Builder().addDependency("org.apache.camel.k", "camel-k-knative-consumer").build()).producer((CamelScopedArtifact)new CamelScopedArtifact.Builder().addDependency("org.apache.camel.k", "camel-k-knative-producer").build()).build()).build());
    }

    private void processLoaders(CamelCatalogSpec.Builder specBuilder) {
        if (this.dslsExclusionList != null) {
            this.getLog().info((CharSequence)("dsls.exclusion.list: " + this.dslsExclusionList));
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("yaml")) {
            specBuilder.putLoader("yaml", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-yaml-dsl").addLanguage("yaml").putMetadata("native", "true").build());
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("groovy")) {
            specBuilder.putLoader("groovy", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-groovy-dsl").addLanguage("groovy").putMetadata("native", "false").build());
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("kts")) {
            specBuilder.putLoader("kts", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-kotlin-dsl").addLanguage("kts").putMetadata("native", "false").build());
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("js")) {
            specBuilder.putLoader("js", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-js-dsl").addLanguage("js").putMetadata("native", "true").build());
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("xml")) {
            specBuilder.putLoader("xml", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-xml-io-dsl").addLanguage("xml").putMetadata("native", "true").build());
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("java")) {
            specBuilder.putLoader("java", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.quarkus", (String)"camel-quarkus-java-joor-dsl").addLanguages(new String[]{"java"}).putMetadata("native", "false").build());
        }
        if (this.dslsExclusionList != null && !this.dslsExclusionList.contains("jsh")) {
            specBuilder.putLoader("jsh", (CamelLoader)CamelLoader.fromArtifact((String)"org.apache.camel.k", (String)"camel-k-loader-jsh").addLanguages(new String[]{"jsh"}).putMetadata("native", "false").build());
        }
    }

    private void processComponents(CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        TreeSet elements = new TreeSet(catalog.findComponentNames());
        if (this.componentsExclusionList != null) {
            this.getLog().info((CharSequence)("components.exclusion.list: " + this.componentsExclusionList));
            elements.removeAll(this.componentsExclusionList);
        }
        for (String name : elements) {
            String json = catalog.componentJSonSchema(name);
            CatalogComponentDefinition definition = CatalogSupport.unmarshallComponent((String)json);
            artifacts.compute(definition.getArtifactId(), (key, artifact) -> {
                CamelArtifact.Builder builder = this.artifactBuilder((CamelArtifact)artifact, (CatalogDefinition)definition);
                builder.addJavaType(definition.getJavaType());
                definition.getSchemes().map(StringUtils::trimToNull).filter(Objects::nonNull).forEach(scheme -> builder.addScheme((CamelScheme)new CamelScheme.Builder().id(scheme).http(KNOWN_HTTP_URIS.contains(scheme)).passive(KNOWN_PASSIVE_URIS.contains(scheme)).build()));
                return builder.build();
            });
        }
    }

    private void processLanguages(CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        TreeSet elements = new TreeSet(catalog.findLanguageNames());
        if (this.languagesExclusionList != null) {
            this.getLog().info((CharSequence)("languages.exclusion.list: " + this.languagesExclusionList));
            elements.removeAll(this.languagesExclusionList);
        }
        for (String name : elements) {
            String json = catalog.languageJSonSchema(name);
            CatalogLanguageDefinition definition = CatalogSupport.unmarshallLanguage((String)json);
            artifacts.compute(definition.getArtifactId(), (key, artifact) -> {
                CamelArtifact.Builder builder = this.artifactBuilder((CamelArtifact)artifact, (CatalogDefinition)definition);
                builder.addLanguage(definition.getName());
                builder.addJavaType(definition.getJavaType());
                return builder.build();
            });
        }
    }

    private void processDataFormats(CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        TreeSet elements = new TreeSet(catalog.findDataFormatNames());
        if (this.dataformatsExclusionList != null) {
            this.getLog().info((CharSequence)("dataformats.exclusion.list: " + this.dataformatsExclusionList));
            elements.removeAll(this.dataformatsExclusionList);
        }
        for (String name : elements) {
            String json = catalog.dataFormatJSonSchema(name);
            CatalogDataFormatDefinition definition = CatalogSupport.unmarshallDataFormat((String)json);
            artifacts.compute(definition.getArtifactId(), (key, artifact) -> {
                CamelArtifact.Builder builder = this.artifactBuilder((CamelArtifact)artifact, (CatalogDefinition)definition);
                builder.addDataformat(definition.getName());
                builder.addJavaType(definition.getJavaType());
                return builder.build();
            });
        }
    }

    private CamelArtifact.Builder artifactBuilder(CamelArtifact artifact, CatalogDefinition definition) {
        CamelArtifact.Builder builder = new CamelArtifact.Builder();
        if (artifact != null) {
            builder.from(artifact);
        } else {
            Objects.requireNonNull(definition.getGroupId());
            Objects.requireNonNull(definition.getArtifactId());
            builder.groupId(definition.getGroupId());
            builder.artifactId(definition.getArtifactId());
        }
        return builder;
    }
}

