/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CamelLoader;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec;
import org.immutables.value.Generated;

@Generated(from="CamelCatalogSpec", generator="Immutables")
public final class ImmutableCamelCatalogSpec
implements CamelCatalogSpec {
    private final RuntimeSpec runtime;
    private final Map<String, CamelArtifact> artifacts;
    private final Map<String, CamelLoader> loaders;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelCatalogSpec(Builder builder) {
        this.runtime = builder.runtime;
        if (builder.artifactsIsSet()) {
            this.initShim.artifacts(ImmutableCamelCatalogSpec.createUnmodifiableMap(false, false, builder.artifacts));
        }
        if (builder.loadersIsSet()) {
            this.initShim.loaders(ImmutableCamelCatalogSpec.createUnmodifiableMap(false, false, builder.loaders));
        }
        this.artifacts = this.initShim.getArtifacts();
        this.loaders = this.initShim.getLoaders();
        this.initShim = null;
    }

    private ImmutableCamelCatalogSpec(RuntimeSpec runtime, Map<String, CamelArtifact> artifacts, Map<String, CamelLoader> loaders) {
        this.runtime = runtime;
        this.artifacts = artifacts;
        this.loaders = loaders;
        this.initShim = null;
    }

    private Map<String, CamelArtifact> getArtifactsInitialize() {
        return CamelCatalogSpec.super.getArtifacts();
    }

    private Map<String, CamelLoader> getLoadersInitialize() {
        return CamelCatalogSpec.super.getLoaders();
    }

    @Override
    @JsonProperty(value="runtime")
    public RuntimeSpec getRuntime() {
        return this.runtime;
    }

    @Override
    @JsonProperty(value="artifacts")
    public Map<String, CamelArtifact> getArtifacts() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getArtifacts() : this.artifacts;
    }

    @Override
    @JsonProperty(value="loaders")
    public Map<String, CamelLoader> getLoaders() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLoaders() : this.loaders;
    }

    public final ImmutableCamelCatalogSpec withRuntime(RuntimeSpec value) {
        if (this.runtime == value) {
            return this;
        }
        RuntimeSpec newValue = Objects.requireNonNull(value, "runtime");
        return new ImmutableCamelCatalogSpec(newValue, this.artifacts, this.loaders);
    }

    public final ImmutableCamelCatalogSpec withArtifacts(Map<String, ? extends CamelArtifact> entries) {
        if (this.artifacts == entries) {
            return this;
        }
        Map<String, CamelArtifact> newValue = ImmutableCamelCatalogSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableCamelCatalogSpec(this.runtime, newValue, this.loaders);
    }

    public final ImmutableCamelCatalogSpec withLoaders(Map<String, ? extends CamelLoader> entries) {
        if (this.loaders == entries) {
            return this;
        }
        Map<String, CamelLoader> newValue = ImmutableCamelCatalogSpec.createUnmodifiableMap(true, false, entries);
        return new ImmutableCamelCatalogSpec(this.runtime, this.artifacts, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelCatalogSpec && this.equalTo((ImmutableCamelCatalogSpec)another);
    }

    private boolean equalTo(ImmutableCamelCatalogSpec another) {
        return this.runtime.equals(another.runtime) && this.artifacts.equals(another.artifacts) && this.loaders.equals(another.loaders);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.runtime.hashCode();
        h += (h << 5) + this.artifacts.hashCode();
        h += (h << 5) + this.loaders.hashCode();
        return h;
    }

    public String toString() {
        return "CamelCatalogSpec{runtime=" + this.runtime + ", artifacts=" + this.artifacts + ", loaders=" + this.loaders + "}";
    }

    public static ImmutableCamelCatalogSpec copyOf(CamelCatalogSpec instance) {
        if (instance instanceof ImmutableCamelCatalogSpec) {
            return (ImmutableCamelCatalogSpec)instance;
        }
        return new CamelCatalogSpec.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @JsonPropertyOrder(value={"runtime", "artifacts"})
    @Generated(from="CamelCatalogSpec", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_RUNTIME = 1L;
        private static final long OPT_BIT_ARTIFACTS = 1L;
        private static final long OPT_BIT_LOADERS = 2L;
        private long initBits = 1L;
        private long optBits;
        private RuntimeSpec runtime;
        private Map<String, CamelArtifact> artifacts = new LinkedHashMap<String, CamelArtifact>();
        private Map<String, CamelLoader> loaders = new LinkedHashMap<String, CamelLoader>();

        public Builder() {
            if (!(this instanceof CamelCatalogSpec.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelCatalogSpec.Builder()");
            }
        }

        public final CamelCatalogSpec.Builder from(CamelCatalogSpec instance) {
            Objects.requireNonNull(instance, "instance");
            this.runtime(instance.getRuntime());
            this.putAllArtifacts(instance.getArtifacts());
            this.putAllLoaders(instance.getLoaders());
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="runtime")
        public final CamelCatalogSpec.Builder runtime(RuntimeSpec runtime) {
            this.runtime = Objects.requireNonNull(runtime, "runtime");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelCatalogSpec.Builder)this;
        }

        public final CamelCatalogSpec.Builder putArtifact(String key, CamelArtifact value) {
            this.artifacts.put(Objects.requireNonNull(key, "artifacts key"), Objects.requireNonNull(value, "artifacts value"));
            this.optBits |= 1L;
            return (CamelCatalogSpec.Builder)this;
        }

        public final CamelCatalogSpec.Builder putArtifact(Map.Entry<String, ? extends CamelArtifact> entry) {
            String k = entry.getKey();
            CamelArtifact v = entry.getValue();
            this.artifacts.put(Objects.requireNonNull(k, "artifacts key"), Objects.requireNonNull(v, "artifacts value"));
            this.optBits |= 1L;
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="artifacts")
        public final CamelCatalogSpec.Builder artifacts(Map<String, ? extends CamelArtifact> entries) {
            this.artifacts.clear();
            this.optBits |= 1L;
            return this.putAllArtifacts(entries);
        }

        public final CamelCatalogSpec.Builder putAllArtifacts(Map<String, ? extends CamelArtifact> entries) {
            for (Map.Entry<String, ? extends CamelArtifact> e : entries.entrySet()) {
                String k = e.getKey();
                CamelArtifact v = e.getValue();
                this.artifacts.put(Objects.requireNonNull(k, "artifacts key"), Objects.requireNonNull(v, "artifacts value"));
            }
            this.optBits |= 1L;
            return (CamelCatalogSpec.Builder)this;
        }

        public final CamelCatalogSpec.Builder putLoader(String key, CamelLoader value) {
            this.loaders.put(Objects.requireNonNull(key, "loaders key"), Objects.requireNonNull(value, "loaders value"));
            this.optBits |= 2L;
            return (CamelCatalogSpec.Builder)this;
        }

        public final CamelCatalogSpec.Builder putLoader(Map.Entry<String, ? extends CamelLoader> entry) {
            String k = entry.getKey();
            CamelLoader v = entry.getValue();
            this.loaders.put(Objects.requireNonNull(k, "loaders key"), Objects.requireNonNull(v, "loaders value"));
            this.optBits |= 2L;
            return (CamelCatalogSpec.Builder)this;
        }

        @JsonProperty(value="loaders")
        public final CamelCatalogSpec.Builder loaders(Map<String, ? extends CamelLoader> entries) {
            this.loaders.clear();
            this.optBits |= 2L;
            return this.putAllLoaders(entries);
        }

        public final CamelCatalogSpec.Builder putAllLoaders(Map<String, ? extends CamelLoader> entries) {
            for (Map.Entry<String, ? extends CamelLoader> e : entries.entrySet()) {
                String k = e.getKey();
                CamelLoader v = e.getValue();
                this.loaders.put(Objects.requireNonNull(k, "loaders key"), Objects.requireNonNull(v, "loaders value"));
            }
            this.optBits |= 2L;
            return (CamelCatalogSpec.Builder)this;
        }

        public ImmutableCamelCatalogSpec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelCatalogSpec(this);
        }

        private boolean artifactsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean loadersIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("runtime");
            }
            return "Cannot build CamelCatalogSpec, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelCatalogSpec", generator="Immutables")
    private final class InitShim {
        private byte artifactsBuildStage = 0;
        private Map<String, CamelArtifact> artifacts;
        private byte loadersBuildStage = 0;
        private Map<String, CamelLoader> loaders;

        private InitShim() {
        }

        Map<String, CamelArtifact> getArtifacts() {
            if (this.artifactsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.artifactsBuildStage == 0) {
                this.artifactsBuildStage = (byte)-1;
                this.artifacts = ImmutableCamelCatalogSpec.createUnmodifiableMap(true, false, ImmutableCamelCatalogSpec.this.getArtifactsInitialize());
                this.artifactsBuildStage = 1;
            }
            return this.artifacts;
        }

        void artifacts(Map<String, CamelArtifact> artifacts) {
            this.artifacts = artifacts;
            this.artifactsBuildStage = 1;
        }

        Map<String, CamelLoader> getLoaders() {
            if (this.loadersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.loadersBuildStage == 0) {
                this.loadersBuildStage = (byte)-1;
                this.loaders = ImmutableCamelCatalogSpec.createUnmodifiableMap(true, false, ImmutableCamelCatalogSpec.this.getLoadersInitialize());
                this.loadersBuildStage = 1;
            }
            return this.loaders;
        }

        void loaders(Map<String, CamelLoader> loaders) {
            this.loaders = loaders;
            this.loadersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.artifactsBuildStage == -1) {
                attributes.add("artifacts");
            }
            if (this.loadersBuildStage == -1) {
                attributes.add("loaders");
            }
            return "Cannot build CamelCatalogSpec, attribute initializers form cycle " + attributes;
        }
    }
}

