/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalog;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta;
import org.immutables.value.Generated;

@Generated(from="CamelCatalog", generator="Immutables")
public final class ImmutableCamelCatalog
implements CamelCatalog {
    private final String apiVersion;
    private final String kind;
    private final ObjectMeta metadata;
    private final CamelCatalogSpec spec;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelCatalog(Builder builder) {
        this.metadata = builder.metadata;
        this.spec = builder.spec;
        if (builder.apiVersion != null) {
            this.initShim.apiVersion(builder.apiVersion);
        }
        if (builder.kind != null) {
            this.initShim.kind(builder.kind);
        }
        this.apiVersion = this.initShim.getApiVersion();
        this.kind = this.initShim.getKind();
        this.initShim = null;
    }

    private ImmutableCamelCatalog(String apiVersion, String kind, ObjectMeta metadata, CamelCatalogSpec spec) {
        this.apiVersion = apiVersion;
        this.kind = kind;
        this.metadata = metadata;
        this.spec = spec;
        this.initShim = null;
    }

    private String getApiVersionInitialize() {
        return CamelCatalog.super.getApiVersion();
    }

    private String getKindInitialize() {
        return CamelCatalog.super.getKind();
    }

    @Override
    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getApiVersion() : this.apiVersion;
    }

    @Override
    @JsonProperty(value="kind")
    public String getKind() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getKind() : this.kind;
    }

    @Override
    @JsonProperty(value="metadata")
    public ObjectMeta getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="spec")
    public CamelCatalogSpec getSpec() {
        return this.spec;
    }

    public final ImmutableCamelCatalog withApiVersion(String value) {
        String newValue = Objects.requireNonNull(value, "apiVersion");
        if (this.apiVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelCatalog(newValue, this.kind, this.metadata, this.spec);
    }

    public final ImmutableCamelCatalog withKind(String value) {
        String newValue = Objects.requireNonNull(value, "kind");
        if (this.kind.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelCatalog(this.apiVersion, newValue, this.metadata, this.spec);
    }

    public final ImmutableCamelCatalog withMetadata(ObjectMeta value) {
        if (this.metadata == value) {
            return this;
        }
        ObjectMeta newValue = Objects.requireNonNull(value, "metadata");
        return new ImmutableCamelCatalog(this.apiVersion, this.kind, newValue, this.spec);
    }

    public final ImmutableCamelCatalog withSpec(CamelCatalogSpec value) {
        if (this.spec == value) {
            return this;
        }
        CamelCatalogSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableCamelCatalog(this.apiVersion, this.kind, this.metadata, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelCatalog && this.equalTo((ImmutableCamelCatalog)another);
    }

    private boolean equalTo(ImmutableCamelCatalog another) {
        return this.apiVersion.equals(another.apiVersion) && this.kind.equals(another.kind) && this.metadata.equals(another.metadata) && this.spec.equals(another.spec);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.apiVersion.hashCode();
        h += (h << 5) + this.kind.hashCode();
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.spec.hashCode();
        return h;
    }

    public String toString() {
        return "CamelCatalog{apiVersion=" + this.apiVersion + ", kind=" + this.kind + ", metadata=" + this.metadata + ", spec=" + this.spec + "}";
    }

    public static ImmutableCamelCatalog copyOf(CamelCatalog instance) {
        if (instance instanceof ImmutableCamelCatalog) {
            return (ImmutableCamelCatalog)instance;
        }
        return new CamelCatalog.Builder().from(instance).build();
    }

    @JsonPropertyOrder(value={"apiVersion", "kind", "metadata", "spec"})
    @Generated(from="CamelCatalog", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_METADATA = 1L;
        private static final long INIT_BIT_SPEC = 2L;
        private long initBits = 3L;
        private String apiVersion;
        private String kind;
        private ObjectMeta metadata;
        private CamelCatalogSpec spec;

        public Builder() {
            if (!(this instanceof CamelCatalog.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelCatalog.Builder()");
            }
        }

        public final CamelCatalog.Builder from(CamelCatalog instance) {
            Objects.requireNonNull(instance, "instance");
            this.apiVersion(instance.getApiVersion());
            this.kind(instance.getKind());
            this.metadata(instance.getMetadata());
            this.spec(instance.getSpec());
            return (CamelCatalog.Builder)this;
        }

        @JsonProperty(value="apiVersion")
        public final CamelCatalog.Builder apiVersion(String apiVersion) {
            this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
            return (CamelCatalog.Builder)this;
        }

        @JsonProperty(value="kind")
        public final CamelCatalog.Builder kind(String kind) {
            this.kind = Objects.requireNonNull(kind, "kind");
            return (CamelCatalog.Builder)this;
        }

        @JsonProperty(value="metadata")
        public final CamelCatalog.Builder metadata(ObjectMeta metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelCatalog.Builder)this;
        }

        @JsonProperty(value="spec")
        public final CamelCatalog.Builder spec(CamelCatalogSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CamelCatalog.Builder)this;
        }

        public ImmutableCamelCatalog build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelCatalog(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spec");
            }
            return "Cannot build CamelCatalog, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelCatalog", generator="Immutables")
    private final class InitShim {
        private byte apiVersionBuildStage = 0;
        private String apiVersion;
        private byte kindBuildStage = 0;
        private String kind;

        private InitShim() {
        }

        String getApiVersion() {
            if (this.apiVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.apiVersionBuildStage == 0) {
                this.apiVersionBuildStage = (byte)-1;
                this.apiVersion = Objects.requireNonNull(ImmutableCamelCatalog.this.getApiVersionInitialize(), "apiVersion");
                this.apiVersionBuildStage = 1;
            }
            return this.apiVersion;
        }

        void apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            this.apiVersionBuildStage = 1;
        }

        String getKind() {
            if (this.kindBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.kindBuildStage == 0) {
                this.kindBuildStage = (byte)-1;
                this.kind = Objects.requireNonNull(ImmutableCamelCatalog.this.getKindInitialize(), "kind");
                this.kindBuildStage = 1;
            }
            return this.kind;
        }

        void kind(String kind) {
            this.kind = kind;
            this.kindBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.apiVersionBuildStage == -1) {
                attributes.add("apiVersion");
            }
            if (this.kindBuildStage == -1) {
                attributes.add("kind");
            }
            return "Cannot build CamelCatalog, attribute initializers form cycle " + attributes;
        }
    }
}

