/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.CamelLoader;
import org.immutables.value.Generated;

@Generated(from="CamelLoader", generator="Immutables")
public final class ImmutableCamelLoader
implements CamelLoader {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Set<String> languages;
    private final Set<Artifact> dependencies;
    private final Map<String, String> metadata;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelLoader(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        if (builder.languagesIsSet()) {
            this.initShim.languages(ImmutableCamelLoader.createUnmodifiableSet(builder.languages));
        }
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies(ImmutableCamelLoader.createUnmodifiableSet(builder.dependencies));
        }
        if (builder.metadataIsSet()) {
            this.initShim.metadata(ImmutableCamelLoader.createUnmodifiableMap(false, false, builder.metadata));
        }
        this.languages = this.initShim.getLanguages();
        this.dependencies = this.initShim.getDependencies();
        this.metadata = this.initShim.getMetadata();
        this.initShim = null;
    }

    private ImmutableCamelLoader(String groupId, String artifactId, String version, Set<String> languages, Set<Artifact> dependencies, Map<String, String> metadata) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.languages = languages;
        this.dependencies = dependencies;
        this.metadata = metadata;
        this.initShim = null;
    }

    private Set<String> getLanguagesInitialize() {
        return CamelLoader.super.getLanguages();
    }

    private Set<Artifact> getDependenciesInitialize() {
        return CamelLoader.super.getDependencies();
    }

    private Map<String, String> getMetadataInitialize() {
        return CamelLoader.super.getMetadata();
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="languages")
    public Set<String> getLanguages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLanguages() : this.languages;
    }

    @Override
    @JsonProperty(value="dependencies")
    public Set<Artifact> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @Override
    @JsonProperty(value="metadata")
    public Map<String, String> getMetadata() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMetadata() : this.metadata;
    }

    public final ImmutableCamelLoader withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelLoader(newValue, this.artifactId, this.version, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelLoader(this.groupId, newValue, this.version, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableCamelLoader(this.groupId, this.artifactId, newValue, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableCamelLoader(this.groupId, this.artifactId, value, this.languages, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withLanguages(String ... elements) {
        Set<String> newValue = ImmutableCamelLoader.createUnmodifiableSet(ImmutableCamelLoader.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, newValue, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withLanguages(Iterable<String> elements) {
        if (this.languages == elements) {
            return this;
        }
        Set<String> newValue = ImmutableCamelLoader.createUnmodifiableSet(ImmutableCamelLoader.createSafeList(elements, true, false));
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, newValue, this.dependencies, this.metadata);
    }

    public final ImmutableCamelLoader withDependencies(Artifact ... elements) {
        Set<Artifact> newValue = ImmutableCamelLoader.createUnmodifiableSet(ImmutableCamelLoader.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, newValue, this.metadata);
    }

    public final ImmutableCamelLoader withDependencies(Iterable<? extends Artifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        Set<Artifact> newValue = ImmutableCamelLoader.createUnmodifiableSet(ImmutableCamelLoader.createSafeList(elements, true, false));
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, newValue, this.metadata);
    }

    public final ImmutableCamelLoader withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableCamelLoader.createUnmodifiableMap(true, false, entries);
        return new ImmutableCamelLoader(this.groupId, this.artifactId, this.version, this.languages, this.dependencies, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelLoader && this.equalTo((ImmutableCamelLoader)another);
    }

    private boolean equalTo(ImmutableCamelLoader another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CamelLoader{");
        builder.append("groupId=").append(this.groupId);
        builder.append(", ");
        builder.append("artifactId=").append(this.artifactId);
        if (this.version != null) {
            builder.append(", ");
            builder.append("version=").append(this.version);
        }
        return builder.append("}").toString();
    }

    public static ImmutableCamelLoader copyOf(CamelLoader instance) {
        if (instance instanceof ImmutableCamelLoader) {
            return (ImmutableCamelLoader)instance;
        }
        return new CamelLoader.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @JsonPropertyOrder(value={"groupId", "artifactId", "version"})
    @Generated(from="CamelLoader", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private static final long OPT_BIT_LANGUAGES = 1L;
        private static final long OPT_BIT_DEPENDENCIES = 2L;
        private static final long OPT_BIT_METADATA = 4L;
        private long initBits = 3L;
        private long optBits;
        private String groupId;
        private String artifactId;
        private String version;
        private List<String> languages = new ArrayList<String>();
        private List<Artifact> dependencies = new ArrayList<Artifact>();
        private Map<String, String> metadata = new LinkedHashMap<String, String>();

        public Builder() {
            if (!(this instanceof CamelLoader.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelLoader.Builder()");
            }
        }

        public final CamelLoader.Builder from(CamelLoader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder from(Artifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelLoader.Builder)this;
        }

        private void from(Object object) {
            Artifact instance;
            if (object instanceof CamelLoader) {
                instance = (CamelLoader)object;
                this.addAllLanguages(instance.getLanguages());
                this.putAllMetadata(instance.getMetadata());
                this.addAllDependencies(instance.getDependencies());
            }
            if (object instanceof Artifact) {
                instance = (Artifact)object;
                Optional<String> versionOptional = instance.getVersion();
                if (versionOptional.isPresent()) {
                    this.version(versionOptional);
                }
                this.artifactId(instance.getArtifactId());
                this.groupId(instance.getGroupId());
            }
        }

        @JsonProperty(value="groupId")
        public final CamelLoader.Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="artifactId")
        public final CamelLoader.Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="version")
        public final CamelLoader.Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addLanguage(String element) {
            this.languages.add(Objects.requireNonNull(element, "languages element"));
            this.optBits |= 1L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addLanguages(String ... elements) {
            for (String element : elements) {
                this.languages.add(Objects.requireNonNull(element, "languages element"));
            }
            this.optBits |= 1L;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="languages")
        public final CamelLoader.Builder languages(Iterable<String> elements) {
            this.languages.clear();
            return this.addAllLanguages(elements);
        }

        public final CamelLoader.Builder addAllLanguages(Iterable<String> elements) {
            for (String element : elements) {
                this.languages.add(Objects.requireNonNull(element, "languages element"));
            }
            this.optBits |= 1L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addDependency(Artifact element) {
            this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            this.optBits |= 2L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder addDependencies(Artifact ... elements) {
            for (Artifact element : elements) {
                this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            }
            this.optBits |= 2L;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="dependencies")
        public final CamelLoader.Builder dependencies(Iterable<? extends Artifact> elements) {
            this.dependencies.clear();
            return this.addAllDependencies(elements);
        }

        public final CamelLoader.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
            for (Artifact artifact : elements) {
                this.dependencies.add(Objects.requireNonNull(artifact, "dependencies element"));
            }
            this.optBits |= 2L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder putMetadata(String key, String value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, "metadata value"));
            this.optBits |= 4L;
            return (CamelLoader.Builder)this;
        }

        public final CamelLoader.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            this.optBits |= 4L;
            return (CamelLoader.Builder)this;
        }

        @JsonProperty(value="metadata")
        public final CamelLoader.Builder metadata(Map<String, ? extends String> entries) {
            this.metadata.clear();
            this.optBits |= 4L;
            return this.putAllMetadata(entries);
        }

        public final CamelLoader.Builder putAllMetadata(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, "metadata value"));
            }
            this.optBits |= 4L;
            return (CamelLoader.Builder)this;
        }

        public ImmutableCamelLoader build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelLoader(this);
        }

        private boolean languagesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean metadataIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build CamelLoader, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelLoader", generator="Immutables")
    private final class InitShim {
        private byte languagesBuildStage = 0;
        private Set<String> languages;
        private byte dependenciesBuildStage = 0;
        private Set<Artifact> dependencies;
        private byte metadataBuildStage = 0;
        private Map<String, String> metadata;

        private InitShim() {
        }

        Set<String> getLanguages() {
            if (this.languagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.languagesBuildStage == 0) {
                this.languagesBuildStage = (byte)-1;
                this.languages = ImmutableCamelLoader.createUnmodifiableSet(ImmutableCamelLoader.createSafeList(ImmutableCamelLoader.this.getLanguagesInitialize(), true, false));
                this.languagesBuildStage = 1;
            }
            return this.languages;
        }

        void languages(Set<String> languages) {
            this.languages = languages;
            this.languagesBuildStage = 1;
        }

        Set<Artifact> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableCamelLoader.createUnmodifiableSet(ImmutableCamelLoader.createSafeList(ImmutableCamelLoader.this.getDependenciesInitialize(), true, false));
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(Set<Artifact> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        Map<String, String> getMetadata() {
            if (this.metadataBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.metadataBuildStage == 0) {
                this.metadataBuildStage = (byte)-1;
                this.metadata = ImmutableCamelLoader.createUnmodifiableMap(true, false, ImmutableCamelLoader.this.getMetadataInitialize());
                this.metadataBuildStage = 1;
            }
            return this.metadata;
        }

        void metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            this.metadataBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.languagesBuildStage == -1) {
                attributes.add("languages");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.metadataBuildStage == -1) {
                attributes.add("metadata");
            }
            return "Cannot build CamelLoader, attribute initializers form cycle " + attributes;
        }
    }
}

