/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CamelScheme;
import org.immutables.value.Generated;

@Generated(from="CamelArtifact", generator="Immutables")
public final class ImmutableCamelArtifact
implements CamelArtifact {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Set<CamelScheme> schemes;
    private final Set<String> languages;
    private final Set<String> dataformats;
    private final Set<Artifact> dependencies;
    private final Set<Artifact> exclusions;
    private final Set<String> javaTypes;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCamelArtifact(Builder builder) {
        this.groupId = builder.groupId;
        this.artifactId = builder.artifactId;
        this.version = builder.version;
        if (builder.schemesIsSet()) {
            this.initShim.schemes(ImmutableCamelArtifact.createUnmodifiableSet(builder.schemes));
        }
        if (builder.languagesIsSet()) {
            this.initShim.languages(ImmutableCamelArtifact.createUnmodifiableSet(builder.languages));
        }
        if (builder.dataformatsIsSet()) {
            this.initShim.dataformats(ImmutableCamelArtifact.createUnmodifiableSet(builder.dataformats));
        }
        if (builder.dependenciesIsSet()) {
            this.initShim.dependencies(ImmutableCamelArtifact.createUnmodifiableSet(builder.dependencies));
        }
        if (builder.exclusionsIsSet()) {
            this.initShim.exclusions(ImmutableCamelArtifact.createUnmodifiableSet(builder.exclusions));
        }
        if (builder.javaTypesIsSet()) {
            this.initShim.javaTypes(ImmutableCamelArtifact.createUnmodifiableSet(builder.javaTypes));
        }
        this.schemes = this.initShim.getSchemes();
        this.languages = this.initShim.getLanguages();
        this.dataformats = this.initShim.getDataformats();
        this.dependencies = this.initShim.getDependencies();
        this.exclusions = this.initShim.getExclusions();
        this.javaTypes = this.initShim.getJavaTypes();
        this.initShim = null;
    }

    private ImmutableCamelArtifact(String groupId, String artifactId, String version, Set<CamelScheme> schemes, Set<String> languages, Set<String> dataformats, Set<Artifact> dependencies, Set<Artifact> exclusions, Set<String> javaTypes) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.schemes = schemes;
        this.languages = languages;
        this.dataformats = dataformats;
        this.dependencies = dependencies;
        this.exclusions = exclusions;
        this.javaTypes = javaTypes;
        this.initShim = null;
    }

    private Set<CamelScheme> getSchemesInitialize() {
        return CamelArtifact.super.getSchemes();
    }

    private Set<String> getLanguagesInitialize() {
        return CamelArtifact.super.getLanguages();
    }

    private Set<String> getDataformatsInitialize() {
        return CamelArtifact.super.getDataformats();
    }

    private Set<Artifact> getDependenciesInitialize() {
        return CamelArtifact.super.getDependencies();
    }

    private Set<Artifact> getExclusionsInitialize() {
        return CamelArtifact.super.getExclusions();
    }

    private Set<String> getJavaTypesInitialize() {
        return CamelArtifact.super.getJavaTypes();
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="artifactId")
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    @JsonProperty(value="version")
    public Optional<String> getVersion() {
        return Optional.ofNullable(this.version);
    }

    @Override
    @JsonProperty(value="schemes")
    public Set<CamelScheme> getSchemes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemes() : this.schemes;
    }

    @Override
    @JsonProperty(value="languages")
    public Set<String> getLanguages() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getLanguages() : this.languages;
    }

    @Override
    @JsonProperty(value="dataformats")
    public Set<String> getDataformats() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDataformats() : this.dataformats;
    }

    @Override
    @JsonProperty(value="dependencies")
    public Set<Artifact> getDependencies() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getDependencies() : this.dependencies;
    }

    @Override
    @JsonProperty(value="exclusions")
    public Set<Artifact> getExclusions() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getExclusions() : this.exclusions;
    }

    @Override
    @JsonProperty(value="javaTypes")
    public Set<String> getJavaTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getJavaTypes() : this.javaTypes;
    }

    public final ImmutableCamelArtifact withGroupId(String value) {
        String newValue = Objects.requireNonNull(value, "groupId");
        if (this.groupId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelArtifact(newValue, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withArtifactId(String value) {
        String newValue = Objects.requireNonNull(value, "artifactId");
        if (this.artifactId.equals(newValue)) {
            return this;
        }
        return new ImmutableCamelArtifact(this.groupId, newValue, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withVersion(String value) {
        String newValue = Objects.requireNonNull(value, "version");
        if (Objects.equals(this.version, newValue)) {
            return this;
        }
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, newValue, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withVersion(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.version, value)) {
            return this;
        }
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, value, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withSchemes(CamelScheme ... elements) {
        Set<CamelScheme> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, newValue, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withSchemes(Iterable<? extends CamelScheme> elements) {
        if (this.schemes == elements) {
            return this;
        }
        Set<CamelScheme> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(elements, true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, newValue, this.languages, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withLanguages(String ... elements) {
        Set<String> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, newValue, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withLanguages(Iterable<String> elements) {
        if (this.languages == elements) {
            return this;
        }
        Set<String> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(elements, true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, newValue, this.dataformats, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDataformats(String ... elements) {
        Set<String> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, newValue, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDataformats(Iterable<String> elements) {
        if (this.dataformats == elements) {
            return this;
        }
        Set<String> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(elements, true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, newValue, this.dependencies, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDependencies(Artifact ... elements) {
        Set<Artifact> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, newValue, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withDependencies(Iterable<? extends Artifact> elements) {
        if (this.dependencies == elements) {
            return this;
        }
        Set<Artifact> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(elements, true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, newValue, this.exclusions, this.javaTypes);
    }

    public final ImmutableCamelArtifact withExclusions(Artifact ... elements) {
        Set<Artifact> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, newValue, this.javaTypes);
    }

    public final ImmutableCamelArtifact withExclusions(Iterable<? extends Artifact> elements) {
        if (this.exclusions == elements) {
            return this;
        }
        Set<Artifact> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(elements, true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, newValue, this.javaTypes);
    }

    public final ImmutableCamelArtifact withJavaTypes(String ... elements) {
        Set<String> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, newValue);
    }

    public final ImmutableCamelArtifact withJavaTypes(Iterable<String> elements) {
        if (this.javaTypes == elements) {
            return this;
        }
        Set<String> newValue = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(elements, true, false));
        return new ImmutableCamelArtifact(this.groupId, this.artifactId, this.version, this.schemes, this.languages, this.dataformats, this.dependencies, this.exclusions, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCamelArtifact && this.equalTo((ImmutableCamelArtifact)another);
    }

    private boolean equalTo(ImmutableCamelArtifact another) {
        return this.groupId.equals(another.groupId) && this.artifactId.equals(another.artifactId) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.artifactId.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CamelArtifact{");
        builder.append("groupId=").append(this.groupId);
        builder.append(", ");
        builder.append("artifactId=").append(this.artifactId);
        if (this.version != null) {
            builder.append(", ");
            builder.append("version=").append(this.version);
        }
        return builder.append("}").toString();
    }

    public static ImmutableCamelArtifact copyOf(CamelArtifact instance) {
        if (instance instanceof ImmutableCamelArtifact) {
            return (ImmutableCamelArtifact)instance;
        }
        return new CamelArtifact.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @JsonPropertyOrder(value={"groupId", "artifactId", "version"})
    @Generated(from="CamelArtifact", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_ARTIFACT_ID = 2L;
        private static final long OPT_BIT_SCHEMES = 1L;
        private static final long OPT_BIT_LANGUAGES = 2L;
        private static final long OPT_BIT_DATAFORMATS = 4L;
        private static final long OPT_BIT_DEPENDENCIES = 8L;
        private static final long OPT_BIT_EXCLUSIONS = 16L;
        private static final long OPT_BIT_JAVA_TYPES = 32L;
        private long initBits = 3L;
        private long optBits;
        private String groupId;
        private String artifactId;
        private String version;
        private List<CamelScheme> schemes = new ArrayList<CamelScheme>();
        private List<String> languages = new ArrayList<String>();
        private List<String> dataformats = new ArrayList<String>();
        private List<Artifact> dependencies = new ArrayList<Artifact>();
        private List<Artifact> exclusions = new ArrayList<Artifact>();
        private List<String> javaTypes = new ArrayList<String>();

        public Builder() {
            if (!(this instanceof CamelArtifact.Builder)) {
                throw new UnsupportedOperationException("Use: new CamelArtifact.Builder()");
            }
        }

        public final CamelArtifact.Builder from(CamelArtifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder from(Artifact instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return (CamelArtifact.Builder)this;
        }

        private void from(Object object) {
            Artifact instance;
            if (object instanceof CamelArtifact) {
                instance = (CamelArtifact)object;
                this.addAllJavaTypes(instance.getJavaTypes());
                this.addAllExclusions(instance.getExclusions());
                this.addAllSchemes(instance.getSchemes());
                this.addAllLanguages(instance.getLanguages());
                this.addAllDataformats(instance.getDataformats());
                this.addAllDependencies(instance.getDependencies());
            }
            if (object instanceof Artifact) {
                instance = (Artifact)object;
                Optional<String> versionOptional = instance.getVersion();
                if (versionOptional.isPresent()) {
                    this.version(versionOptional);
                }
                this.artifactId(instance.getArtifactId());
                this.groupId(instance.getGroupId());
            }
        }

        @JsonProperty(value="groupId")
        public final CamelArtifact.Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="artifactId")
        public final CamelArtifact.Builder artifactId(String artifactId) {
            this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder version(String version) {
            this.version = Objects.requireNonNull(version, "version");
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="version")
        public final CamelArtifact.Builder version(Optional<String> version) {
            this.version = version.orElse(null);
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addScheme(CamelScheme element) {
            this.schemes.add(Objects.requireNonNull(element, "schemes element"));
            this.optBits |= 1L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addSchemes(CamelScheme ... elements) {
            for (CamelScheme element : elements) {
                this.schemes.add(Objects.requireNonNull(element, "schemes element"));
            }
            this.optBits |= 1L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="schemes")
        public final CamelArtifact.Builder schemes(Iterable<? extends CamelScheme> elements) {
            this.schemes.clear();
            return this.addAllSchemes(elements);
        }

        public final CamelArtifact.Builder addAllSchemes(Iterable<? extends CamelScheme> elements) {
            for (CamelScheme camelScheme : elements) {
                this.schemes.add(Objects.requireNonNull(camelScheme, "schemes element"));
            }
            this.optBits |= 1L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addLanguage(String element) {
            this.languages.add(Objects.requireNonNull(element, "languages element"));
            this.optBits |= 2L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addLanguages(String ... elements) {
            for (String element : elements) {
                this.languages.add(Objects.requireNonNull(element, "languages element"));
            }
            this.optBits |= 2L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="languages")
        public final CamelArtifact.Builder languages(Iterable<String> elements) {
            this.languages.clear();
            return this.addAllLanguages(elements);
        }

        public final CamelArtifact.Builder addAllLanguages(Iterable<String> elements) {
            for (String element : elements) {
                this.languages.add(Objects.requireNonNull(element, "languages element"));
            }
            this.optBits |= 2L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addDataformat(String element) {
            this.dataformats.add(Objects.requireNonNull(element, "dataformats element"));
            this.optBits |= 4L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addDataformats(String ... elements) {
            for (String element : elements) {
                this.dataformats.add(Objects.requireNonNull(element, "dataformats element"));
            }
            this.optBits |= 4L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="dataformats")
        public final CamelArtifact.Builder dataformats(Iterable<String> elements) {
            this.dataformats.clear();
            return this.addAllDataformats(elements);
        }

        public final CamelArtifact.Builder addAllDataformats(Iterable<String> elements) {
            for (String element : elements) {
                this.dataformats.add(Objects.requireNonNull(element, "dataformats element"));
            }
            this.optBits |= 4L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addDependency(Artifact element) {
            this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            this.optBits |= 8L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addDependencies(Artifact ... elements) {
            for (Artifact element : elements) {
                this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
            }
            this.optBits |= 8L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="dependencies")
        public final CamelArtifact.Builder dependencies(Iterable<? extends Artifact> elements) {
            this.dependencies.clear();
            return this.addAllDependencies(elements);
        }

        public final CamelArtifact.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
            for (Artifact artifact : elements) {
                this.dependencies.add(Objects.requireNonNull(artifact, "dependencies element"));
            }
            this.optBits |= 8L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addExclusion(Artifact element) {
            this.exclusions.add(Objects.requireNonNull(element, "exclusions element"));
            this.optBits |= 0x10L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addExclusions(Artifact ... elements) {
            for (Artifact element : elements) {
                this.exclusions.add(Objects.requireNonNull(element, "exclusions element"));
            }
            this.optBits |= 0x10L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="exclusions")
        public final CamelArtifact.Builder exclusions(Iterable<? extends Artifact> elements) {
            this.exclusions.clear();
            return this.addAllExclusions(elements);
        }

        public final CamelArtifact.Builder addAllExclusions(Iterable<? extends Artifact> elements) {
            for (Artifact artifact : elements) {
                this.exclusions.add(Objects.requireNonNull(artifact, "exclusions element"));
            }
            this.optBits |= 0x10L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addJavaType(String element) {
            this.javaTypes.add(Objects.requireNonNull(element, "javaTypes element"));
            this.optBits |= 0x20L;
            return (CamelArtifact.Builder)this;
        }

        public final CamelArtifact.Builder addJavaTypes(String ... elements) {
            for (String element : elements) {
                this.javaTypes.add(Objects.requireNonNull(element, "javaTypes element"));
            }
            this.optBits |= 0x20L;
            return (CamelArtifact.Builder)this;
        }

        @JsonProperty(value="javaTypes")
        public final CamelArtifact.Builder javaTypes(Iterable<String> elements) {
            this.javaTypes.clear();
            return this.addAllJavaTypes(elements);
        }

        public final CamelArtifact.Builder addAllJavaTypes(Iterable<String> elements) {
            for (String element : elements) {
                this.javaTypes.add(Objects.requireNonNull(element, "javaTypes element"));
            }
            this.optBits |= 0x20L;
            return (CamelArtifact.Builder)this;
        }

        public ImmutableCamelArtifact build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCamelArtifact(this);
        }

        private boolean schemesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean languagesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean dataformatsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean dependenciesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean exclusionsIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean javaTypesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("artifactId");
            }
            return "Cannot build CamelArtifact, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="CamelArtifact", generator="Immutables")
    private final class InitShim {
        private byte schemesBuildStage = 0;
        private Set<CamelScheme> schemes;
        private byte languagesBuildStage = 0;
        private Set<String> languages;
        private byte dataformatsBuildStage = 0;
        private Set<String> dataformats;
        private byte dependenciesBuildStage = 0;
        private Set<Artifact> dependencies;
        private byte exclusionsBuildStage = 0;
        private Set<Artifact> exclusions;
        private byte javaTypesBuildStage = 0;
        private Set<String> javaTypes;

        private InitShim() {
        }

        Set<CamelScheme> getSchemes() {
            if (this.schemesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemesBuildStage == 0) {
                this.schemesBuildStage = (byte)-1;
                this.schemes = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(ImmutableCamelArtifact.this.getSchemesInitialize(), true, false));
                this.schemesBuildStage = 1;
            }
            return this.schemes;
        }

        void schemes(Set<CamelScheme> schemes) {
            this.schemes = schemes;
            this.schemesBuildStage = 1;
        }

        Set<String> getLanguages() {
            if (this.languagesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.languagesBuildStage == 0) {
                this.languagesBuildStage = (byte)-1;
                this.languages = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(ImmutableCamelArtifact.this.getLanguagesInitialize(), true, false));
                this.languagesBuildStage = 1;
            }
            return this.languages;
        }

        void languages(Set<String> languages) {
            this.languages = languages;
            this.languagesBuildStage = 1;
        }

        Set<String> getDataformats() {
            if (this.dataformatsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dataformatsBuildStage == 0) {
                this.dataformatsBuildStage = (byte)-1;
                this.dataformats = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(ImmutableCamelArtifact.this.getDataformatsInitialize(), true, false));
                this.dataformatsBuildStage = 1;
            }
            return this.dataformats;
        }

        void dataformats(Set<String> dataformats) {
            this.dataformats = dataformats;
            this.dataformatsBuildStage = 1;
        }

        Set<Artifact> getDependencies() {
            if (this.dependenciesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dependenciesBuildStage == 0) {
                this.dependenciesBuildStage = (byte)-1;
                this.dependencies = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(ImmutableCamelArtifact.this.getDependenciesInitialize(), true, false));
                this.dependenciesBuildStage = 1;
            }
            return this.dependencies;
        }

        void dependencies(Set<Artifact> dependencies) {
            this.dependencies = dependencies;
            this.dependenciesBuildStage = 1;
        }

        Set<Artifact> getExclusions() {
            if (this.exclusionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.exclusionsBuildStage == 0) {
                this.exclusionsBuildStage = (byte)-1;
                this.exclusions = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(ImmutableCamelArtifact.this.getExclusionsInitialize(), true, false));
                this.exclusionsBuildStage = 1;
            }
            return this.exclusions;
        }

        void exclusions(Set<Artifact> exclusions) {
            this.exclusions = exclusions;
            this.exclusionsBuildStage = 1;
        }

        Set<String> getJavaTypes() {
            if (this.javaTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.javaTypesBuildStage == 0) {
                this.javaTypesBuildStage = (byte)-1;
                this.javaTypes = ImmutableCamelArtifact.createUnmodifiableSet(ImmutableCamelArtifact.createSafeList(ImmutableCamelArtifact.this.getJavaTypesInitialize(), true, false));
                this.javaTypesBuildStage = 1;
            }
            return this.javaTypes;
        }

        void javaTypes(Set<String> javaTypes) {
            this.javaTypes = javaTypes;
            this.javaTypesBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.schemesBuildStage == -1) {
                attributes.add("schemes");
            }
            if (this.languagesBuildStage == -1) {
                attributes.add("languages");
            }
            if (this.dataformatsBuildStage == -1) {
                attributes.add("dataformats");
            }
            if (this.dependenciesBuildStage == -1) {
                attributes.add("dependencies");
            }
            if (this.exclusionsBuildStage == -1) {
                attributes.add("exclusions");
            }
            if (this.javaTypesBuildStage == -1) {
                attributes.add("javaTypes");
            }
            return "Cannot build CamelArtifact, attribute initializers form cycle " + attributes;
        }
    }
}

