/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.camel.k.tooling.maven.support.IndexerSupport;
import org.apache.camel.k.tooling.maven.support.MavenSupport;
import org.apache.camel.util.function.Suppliers;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;

public abstract class GenerateYamlSupport
extends AbstractMojo {
    public static final DotName LIST_CLASS = DotName.createSimple((String)"java.util.List");
    public static final DotName XML_ROOT_ELEMENT_ANNOTATION_CLASS = DotName.createSimple((String)"javax.xml.bind.annotation.XmlRootElement");
    public static final DotName XML_ATTRIBUTE_ANNOTATION_CLASS = DotName.createSimple((String)"javax.xml.bind.annotation.XmlAttribute");
    public static final DotName XML_VALUE_ANNOTATION_CLASS = DotName.createSimple((String)"javax.xml.bind.annotation.XmlValue");
    public static final DotName XML_TRANSIENT_CLASS = DotName.createSimple((String)"javax.xml.bind.annotation.XmlTransient");
    public static final DotName JSON_PROPERTY_CLASS = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonProperty");
    public static final DotName JSON_IGNORE_CLASS = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonIgnore");
    public static final DotName JSON_ALIAS_CLASS = DotName.createSimple((String)"com.fasterxml.jackson.annotation.JsonAlias");
    public static final DotName METADATA_ANNOTATION = DotName.createSimple((String)"org.apache.camel.spi.Metadata");
    public static final DotName EXPRESSION_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.language.ExpressionDefinition");
    public static final DotName DATAFORMAT_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.DataFormatDefinition");
    public static final DotName ERROR_HANDLER_CLASS = DotName.createSimple((String)"org.apache.camel.builder.ErrorHandlerBuilder");
    public static final DotName YAML_NODE_DEFINITION_ANNOTATION = DotName.createSimple((String)"org.apache.camel.k.annotation.yaml.YAMLNodeDefinition");
    public static final DotName YAML_STEP_PARSER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.k.annotation.yaml.YAMLStepParser");
    public static final DotName YAML_MIXIN_ANNOTATION = DotName.createSimple((String)"org.apache.camel.k.annotation.yaml.YAMLMixIn");
    public static final DotName JSON_SCHEMA_IGNORE_ANNOTATION = DotName.createSimple((String)"org.apache.camel.k.annotation.yaml.JsonSchemaIgnore");
    public static final DotName LOAD_BALANCE_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.LoadBalancerDefinition");
    public static final DotName START_STEP_PARSER_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.spi.StartStepParser");
    public static final DotName PROCESSOR_STEP_PARSER_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.spi.ProcessorStepParser");
    public static final DotName HAS_EXPRESSION_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.parser.HasExpression");
    public static final DotName HAS_DATAFORMAT_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.parser.HasDataFormat");
    public static final DotName HAS_ENDPOINT_CONSUMER_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.parser.HasEndpointConsumer");
    public static final DotName HAS_ENDPOINT_PRODUCER_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.parser.HasEndpointProducer");
    public static final DotName HAS_URI_PRODUCER_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.parser.HasUri");
    public static final DotName STEP_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.model.Step");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    protected final Supplier<IndexView> view = Suppliers.memorize(() -> IndexerSupport.get(this.project));

    GenerateYamlSupport() {
    }

    protected Map<String, ClassInfo> definitions(DotName type) {
        HashMap<String, ClassInfo> definitions = new HashMap<String, ClassInfo>();
        for (ClassInfo ci : this.view.get().getAllKnownSubclasses(type)) {
            AnnotationValue name;
            AnnotationInstance instance = ci.classAnnotation(XML_ROOT_ELEMENT_ANNOTATION_CLASS);
            if (instance == null || (name = instance.value("name")) == null) continue;
            definitions.put(name.asString(), ci);
        }
        return Collections.unmodifiableMap(definitions);
    }

    protected Stream<ClassInfo> implementors(DotName type) {
        return this.view.get().getAllKnownImplementors(type).stream();
    }

    protected Stream<ClassInfo> annotated(DotName type) {
        return this.view.get().getAnnotations(type).stream().map(AnnotationInstance::target).filter(t -> t.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass);
    }

    protected Optional<AnnotationValue> annotationValue(AnnotationInstance instance, String name) {
        return instance != null ? Optional.ofNullable(instance.value(name)) : Optional.empty();
    }

    protected Optional<AnnotationValue> annotationValue(ClassInfo target, DotName annotationName, String name) {
        return this.annotationValue(target.classAnnotation(annotationName), name);
    }

    protected Optional<AnnotationValue> annotationValue(FieldInfo target, DotName annotationName, String name) {
        return this.annotationValue(target.annotation(annotationName), name);
    }

    protected Optional<AnnotationValue> annotationValue(MethodInfo target, DotName annotationName, String name) {
        return this.annotationValue(target.annotation(annotationName), name);
    }

    protected Class<?> loadClass(ClassInfo ci) {
        return this.loadClass(ci.name().toString());
    }

    protected Class<?> loadClass(String className) {
        try {
            return MavenSupport.getClassLoader(this.project).loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

