package org.apache.camel.k.tooling.maven.model.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link TypeMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new TypeMeta.Builder()}.
 */
@Generated(from = "TypeMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableTypeMeta implements TypeMeta {
  private final String apiVersion;
  private final String kind;

  private ImmutableTypeMeta(ImmutableTypeMeta.Builder builder) {
    if (builder.apiVersion != null) {
      initShim.apiVersion(builder.apiVersion);
    }
    if (builder.kind != null) {
      initShim.kind(builder.kind);
    }
    this.apiVersion = initShim.getApiVersion();
    this.kind = initShim.getKind();
    this.initShim = null;
  }

  private ImmutableTypeMeta(String apiVersion, String kind) {
    this.apiVersion = apiVersion;
    this.kind = kind;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "TypeMeta", generator = "Immutables")
  private final class InitShim {
    private byte apiVersionBuildStage = STAGE_UNINITIALIZED;
    private String apiVersion;

    String getApiVersion() {
      if (apiVersionBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (apiVersionBuildStage == STAGE_UNINITIALIZED) {
        apiVersionBuildStage = STAGE_INITIALIZING;
        this.apiVersion = Objects.requireNonNull(getApiVersionInitialize(), "apiVersion");
        apiVersionBuildStage = STAGE_INITIALIZED;
      }
      return this.apiVersion;
    }

    void apiVersion(String apiVersion) {
      this.apiVersion = apiVersion;
      apiVersionBuildStage = STAGE_INITIALIZED;
    }

    private byte kindBuildStage = STAGE_UNINITIALIZED;
    private String kind;

    String getKind() {
      if (kindBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (kindBuildStage == STAGE_UNINITIALIZED) {
        kindBuildStage = STAGE_INITIALIZING;
        this.kind = Objects.requireNonNull(getKindInitialize(), "kind");
        kindBuildStage = STAGE_INITIALIZED;
      }
      return this.kind;
    }

    void kind(String kind) {
      this.kind = kind;
      kindBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (apiVersionBuildStage == STAGE_INITIALIZING) attributes.add("apiVersion");
      if (kindBuildStage == STAGE_INITIALIZING) attributes.add("kind");
      return "Cannot build TypeMeta, attribute initializers form cycle " + attributes;
    }
  }

  private String getApiVersionInitialize() {
    return TypeMeta.super.getApiVersion();
  }

  private String getKindInitialize() {
    return TypeMeta.super.getKind();
  }

  /**
   * @return The value of the {@code apiVersion} attribute
   */
  @JsonProperty("apiVersion")
  @Override
  public String getApiVersion() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getApiVersion()
        : this.apiVersion;
  }

  /**
   * @return The value of the {@code kind} attribute
   */
  @JsonProperty("kind")
  @Override
  public String getKind() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getKind()
        : this.kind;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TypeMeta#getApiVersion() apiVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apiVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeMeta withApiVersion(String value) {
    String newValue = Objects.requireNonNull(value, "apiVersion");
    if (this.apiVersion.equals(newValue)) return this;
    return new ImmutableTypeMeta(newValue, this.kind);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TypeMeta#getKind() kind} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for kind
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTypeMeta withKind(String value) {
    String newValue = Objects.requireNonNull(value, "kind");
    if (this.kind.equals(newValue)) return this;
    return new ImmutableTypeMeta(this.apiVersion, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTypeMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTypeMeta
        && equalTo((ImmutableTypeMeta) another);
  }

  private boolean equalTo(ImmutableTypeMeta another) {
    return apiVersion.equals(another.apiVersion)
        && kind.equals(another.kind);
  }

  /**
   * Computes a hash code from attributes: {@code apiVersion}, {@code kind}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + apiVersion.hashCode();
    h += (h << 5) + kind.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TypeMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "TypeMeta{"
        + "apiVersion=" + apiVersion
        + ", kind=" + kind
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link TypeMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TypeMeta instance
   */
  public static ImmutableTypeMeta copyOf(TypeMeta instance) {
    if (instance instanceof ImmutableTypeMeta) {
      return (ImmutableTypeMeta) instance;
    }
    return new TypeMeta.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableTypeMeta ImmutableTypeMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TypeMeta", generator = "Immutables")
  public static class Builder {
    private String apiVersion;
    private String kind;

    /**
     * Creates a builder for {@link ImmutableTypeMeta ImmutableTypeMeta} instances.
     * <pre>
     * new TypeMeta.Builder()
     *    .apiVersion(String) // optional {@link TypeMeta#getApiVersion() apiVersion}
     *    .kind(String) // optional {@link TypeMeta#getKind() kind}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof TypeMeta.Builder)) {
        throw new UnsupportedOperationException("Use: new TypeMeta.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code TypeMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final TypeMeta.Builder from(TypeMeta instance) {
      Objects.requireNonNull(instance, "instance");
      apiVersion(instance.getApiVersion());
      kind(instance.getKind());
      return (TypeMeta.Builder) this;
    }

    /**
     * Initializes the value for the {@link TypeMeta#getApiVersion() apiVersion} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TypeMeta#getApiVersion() apiVersion}.</em>
     * @param apiVersion The value for apiVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("apiVersion")
    public final TypeMeta.Builder apiVersion(String apiVersion) {
      this.apiVersion = Objects.requireNonNull(apiVersion, "apiVersion");
      return (TypeMeta.Builder) this;
    }

    /**
     * Initializes the value for the {@link TypeMeta#getKind() kind} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TypeMeta#getKind() kind}.</em>
     * @param kind The value for kind 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("kind")
    public final TypeMeta.Builder kind(String kind) {
      this.kind = Objects.requireNonNull(kind, "kind");
      return (TypeMeta.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableTypeMeta ImmutableTypeMeta}.
     * @return An immutable instance of TypeMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTypeMeta build() {
      return new ImmutableTypeMeta(this);
    }
  }
}
