package org.apache.camel.k.tooling.maven.model.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ObjectMeta}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new ObjectMeta.Builder()}.
 */
@Generated(from = "ObjectMeta", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableObjectMeta implements ObjectMeta {
  private final String name;
  private final Map<String, String> labels;

  private ImmutableObjectMeta(ImmutableObjectMeta.Builder builder) {
    this.name = builder.name;
    this.labels = builder.labelsIsSet()
        ? createUnmodifiableMap(false, false, builder.labels)
        : createUnmodifiableMap(true, false, ObjectMeta.super.getLabels());
  }

  private ImmutableObjectMeta(String name, Map<String, String> labels) {
    this.name = name;
    this.labels = labels;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code labels} attribute
   */
  @JsonProperty("labels")
  @Override
  public Map<String, String> getLabels() {
    return labels;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectMeta#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableObjectMeta withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableObjectMeta(newValue, this.labels);
  }

  /**
   * Copy the current immutable object by replacing the {@link ObjectMeta#getLabels() labels} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the labels map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableObjectMeta withLabels(Map<String, ? extends String> entries) {
    if (this.labels == entries) return this;
    Map<String, String> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableObjectMeta(this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableObjectMeta} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableObjectMeta
        && equalTo((ImmutableObjectMeta) another);
  }

  private boolean equalTo(ImmutableObjectMeta another) {
    return name.equals(another.name)
        && labels.equals(another.labels);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code labels}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + labels.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ObjectMeta} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ObjectMeta{"
        + "name=" + name
        + ", labels=" + labels
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ObjectMeta} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ObjectMeta instance
   */
  public static ImmutableObjectMeta copyOf(ObjectMeta instance) {
    if (instance instanceof ImmutableObjectMeta) {
      return (ImmutableObjectMeta) instance;
    }
    return new ObjectMeta.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableObjectMeta ImmutableObjectMeta}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ObjectMeta", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long OPT_BIT_LABELS = 0x1L;
    private long initBits = 0x1L;
    private long optBits;

    private String name;
    private Map<String, String> labels = new LinkedHashMap<String, String>();

    /**
     * Creates a builder for {@link ImmutableObjectMeta ImmutableObjectMeta} instances.
     * <pre>
     * new ObjectMeta.Builder()
     *    .name(String) // required {@link ObjectMeta#getName() name}
     *    .putLabels|putAllLabels(String =&gt; String) // {@link ObjectMeta#getLabels() labels} mappings
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof ObjectMeta.Builder)) {
        throw new UnsupportedOperationException("Use: new ObjectMeta.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code ObjectMeta} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final ObjectMeta.Builder from(ObjectMeta instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      putAllLabels(instance.getLabels());
      return (ObjectMeta.Builder) this;
    }

    /**
     * Initializes the value for the {@link ObjectMeta#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final ObjectMeta.Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return (ObjectMeta.Builder) this;
    }

    /**
     * Put one entry to the {@link ObjectMeta#getLabels() labels} map.
     * @param key The key in the labels map
     * @param value The associated value in the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final ObjectMeta.Builder putLabels(String key, String value) {
      this.labels.put(
          Objects.requireNonNull(key, "labels key"),
          Objects.requireNonNull(value, "labels value"));
      optBits |= OPT_BIT_LABELS;
      return (ObjectMeta.Builder) this;
    }

    /**
     * Put one entry to the {@link ObjectMeta#getLabels() labels} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final ObjectMeta.Builder putLabels(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.labels.put(
          Objects.requireNonNull(k, "labels key"),
          Objects.requireNonNull(v, "labels value"));
      optBits |= OPT_BIT_LABELS;
      return (ObjectMeta.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ObjectMeta#getLabels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("labels")
    public final ObjectMeta.Builder labels(Map<String, ? extends String> entries) {
      this.labels.clear();
      optBits |= OPT_BIT_LABELS;
      return putAllLabels(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ObjectMeta#getLabels() labels} map. Nulls are not permitted
     * @param entries The entries that will be added to the labels map
     * @return {@code this} builder for use in a chained invocation
     */
    public final ObjectMeta.Builder putAllLabels(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.labels.put(
            Objects.requireNonNull(k, "labels key"),
            Objects.requireNonNull(v, "labels value"));
      }
      optBits |= OPT_BIT_LABELS;
      return (ObjectMeta.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableObjectMeta ImmutableObjectMeta}.
     * @return An immutable instance of ObjectMeta
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableObjectMeta build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableObjectMeta(this);
    }

    private boolean labelsIsSet() {
      return (optBits & OPT_BIT_LABELS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build ObjectMeta, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
