package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MavenArtifact}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new MavenArtifact.Builder()}.
 */
@Generated(from = "MavenArtifact", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableMavenArtifact implements MavenArtifact {
  private final String groupId;
  private final String artifactId;
  private final String version;

  private ImmutableMavenArtifact(String groupId, String artifactId, String version) {
    this.groupId = groupId;
    this.artifactId = artifactId;
    this.version = version;
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code artifactId} attribute
   */
  @JsonProperty("artifactId")
  @Override
  public String getArtifactId() {
    return artifactId;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public Optional<String> getVersion() {
    return Optional.ofNullable(version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MavenArtifact#getGroupId() groupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMavenArtifact withGroupId(String value) {
    String newValue = Objects.requireNonNull(value, "groupId");
    if (this.groupId.equals(newValue)) return this;
    return new ImmutableMavenArtifact(newValue, this.artifactId, this.version);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MavenArtifact#getArtifactId() artifactId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for artifactId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMavenArtifact withArtifactId(String value) {
    String newValue = Objects.requireNonNull(value, "artifactId");
    if (this.artifactId.equals(newValue)) return this;
    return new ImmutableMavenArtifact(this.groupId, newValue, this.version);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link MavenArtifact#getVersion() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMavenArtifact withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return new ImmutableMavenArtifact(this.groupId, this.artifactId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link MavenArtifact#getVersion() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMavenArtifact withVersion(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableMavenArtifact(this.groupId, this.artifactId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMavenArtifact} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMavenArtifact
        && equalTo((ImmutableMavenArtifact) another);
  }

  private boolean equalTo(ImmutableMavenArtifact another) {
    return groupId.equals(another.groupId)
        && artifactId.equals(another.artifactId)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + artifactId.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code MavenArtifact} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("MavenArtifact{");
    builder.append("groupId=").append(groupId);
    builder.append(", ");
    builder.append("artifactId=").append(artifactId);
    if (version != null) {
      builder.append(", ");
      builder.append("version=").append(version);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link MavenArtifact} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MavenArtifact instance
   */
  public static ImmutableMavenArtifact copyOf(MavenArtifact instance) {
    if (instance instanceof ImmutableMavenArtifact) {
      return (ImmutableMavenArtifact) instance;
    }
    return new MavenArtifact.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableMavenArtifact ImmutableMavenArtifact}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MavenArtifact", generator = "Immutables")
  @JsonPropertyOrder({"groupId", "artifactId", "version"})
  public static class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
    private long initBits = 0x3L;

    private String groupId;
    private String artifactId;
    private String version;

    /**
     * Creates a builder for {@link ImmutableMavenArtifact ImmutableMavenArtifact} instances.
     * <pre>
     * new MavenArtifact.Builder()
     *    .groupId(String) // required {@link MavenArtifact#getGroupId() groupId}
     *    .artifactId(String) // required {@link MavenArtifact#getArtifactId() artifactId}
     *    .version(String) // optional {@link MavenArtifact#getVersion() version}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof MavenArtifact.Builder)) {
        throw new UnsupportedOperationException("Use: new MavenArtifact.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.Artifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final MavenArtifact.Builder from(Artifact instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (MavenArtifact.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.MavenArtifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final MavenArtifact.Builder from(MavenArtifact instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (MavenArtifact.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof Artifact) {
        Artifact instance = (Artifact) object;
        Optional<String> versionOptional = instance.getVersion();
        if (versionOptional.isPresent()) {
          version(versionOptional);
        }
        artifactId(instance.getArtifactId());
        groupId(instance.getGroupId());
      }
    }

    /**
     * Initializes the value for the {@link MavenArtifact#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final MavenArtifact.Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return (MavenArtifact.Builder) this;
    }

    /**
     * Initializes the value for the {@link MavenArtifact#getArtifactId() artifactId} attribute.
     * @param artifactId The value for artifactId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("artifactId")
    public final MavenArtifact.Builder artifactId(String artifactId) {
      this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
      initBits &= ~INIT_BIT_ARTIFACT_ID;
      return (MavenArtifact.Builder) this;
    }

    /**
     * Initializes the optional value {@link MavenArtifact#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    public final MavenArtifact.Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return (MavenArtifact.Builder) this;
    }

    /**
     * Initializes the optional value {@link MavenArtifact#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final MavenArtifact.Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return (MavenArtifact.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableMavenArtifact ImmutableMavenArtifact}.
     * @return An immutable instance of MavenArtifact
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMavenArtifact build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMavenArtifact(groupId, artifactId, version);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ARTIFACT_ID) != 0) attributes.add("artifactId");
      return "Cannot build MavenArtifact, some of required attributes are not set " + attributes;
    }
  }
}
