package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelScheme}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelScheme.Builder()}.
 */
@Generated(from = "CamelScheme", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelScheme implements CamelScheme {
  private final String id;
  private final boolean http;
  private final boolean passive;

  private ImmutableCamelScheme(ImmutableCamelScheme.Builder builder) {
    this.id = builder.id;
    if (builder.httpIsSet()) {
      initShim.http(builder.http);
    }
    if (builder.passiveIsSet()) {
      initShim.passive(builder.passive);
    }
    this.http = initShim.http();
    this.passive = initShim.passive();
    this.initShim = null;
  }

  private ImmutableCamelScheme(String id, boolean http, boolean passive) {
    this.id = id;
    this.http = http;
    this.passive = passive;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CamelScheme", generator = "Immutables")
  private final class InitShim {
    private byte httpBuildStage = STAGE_UNINITIALIZED;
    private boolean http;

    boolean http() {
      if (httpBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (httpBuildStage == STAGE_UNINITIALIZED) {
        httpBuildStage = STAGE_INITIALIZING;
        this.http = httpInitialize();
        httpBuildStage = STAGE_INITIALIZED;
      }
      return this.http;
    }

    void http(boolean http) {
      this.http = http;
      httpBuildStage = STAGE_INITIALIZED;
    }

    private byte passiveBuildStage = STAGE_UNINITIALIZED;
    private boolean passive;

    boolean passive() {
      if (passiveBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (passiveBuildStage == STAGE_UNINITIALIZED) {
        passiveBuildStage = STAGE_INITIALIZING;
        this.passive = passiveInitialize();
        passiveBuildStage = STAGE_INITIALIZED;
      }
      return this.passive;
    }

    void passive(boolean passive) {
      this.passive = passive;
      passiveBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (httpBuildStage == STAGE_INITIALIZING) attributes.add("http");
      if (passiveBuildStage == STAGE_INITIALIZING) attributes.add("passive");
      return "Cannot build CamelScheme, attribute initializers form cycle " + attributes;
    }
  }

  private boolean httpInitialize() {
    return CamelScheme.super.http();
  }

  private boolean passiveInitialize() {
    return CamelScheme.super.passive();
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code http} attribute
   */
  @JsonProperty("http")
  @Override
  public boolean http() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.http()
        : this.http;
  }

  /**
   * @return The value of the {@code passive} attribute
   */
  @JsonProperty("passive")
  @Override
  public boolean passive() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.passive()
        : this.passive;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelScheme#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelScheme withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableCamelScheme(newValue, this.http, this.passive);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelScheme#http() http} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for http
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelScheme withHttp(boolean value) {
    if (this.http == value) return this;
    return new ImmutableCamelScheme(this.id, value, this.passive);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelScheme#passive() passive} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for passive
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelScheme withPassive(boolean value) {
    if (this.passive == value) return this;
    return new ImmutableCamelScheme(this.id, this.http, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelScheme} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelScheme
        && equalTo((ImmutableCamelScheme) another);
  }

  private boolean equalTo(ImmutableCamelScheme another) {
    return id.equals(another.id);
  }

  /**
   * Computes a hash code from attributes: {@code id}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CamelScheme} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CamelScheme{"
        + "id=" + id
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link CamelScheme} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelScheme instance
   */
  public static ImmutableCamelScheme copyOf(CamelScheme instance) {
    if (instance instanceof ImmutableCamelScheme) {
      return (ImmutableCamelScheme) instance;
    }
    return new CamelScheme.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelScheme ImmutableCamelScheme}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelScheme", generator = "Immutables")
  public static class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long OPT_BIT_HTTP = 0x1L;
    private static final long OPT_BIT_PASSIVE = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private String id;
    private boolean http;
    private boolean passive;

    /**
     * Creates a builder for {@link ImmutableCamelScheme ImmutableCamelScheme} instances.
     * <pre>
     * new CamelScheme.Builder()
     *    .id(String) // required {@link CamelScheme#getId() id}
     *    .http(boolean) // optional {@link CamelScheme#http() http}
     *    .passive(boolean) // optional {@link CamelScheme#passive() passive}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelScheme.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelScheme.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CamelScheme} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelScheme.Builder from(CamelScheme instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      http(instance.http());
      passive(instance.passive());
      return (CamelScheme.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelScheme#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final CamelScheme.Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return (CamelScheme.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelScheme#http() http} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelScheme#http() http}.</em>
     * @param http The value for http 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("http")
    public final CamelScheme.Builder http(boolean http) {
      this.http = http;
      optBits |= OPT_BIT_HTTP;
      return (CamelScheme.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelScheme#passive() passive} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelScheme#passive() passive}.</em>
     * @param passive The value for passive 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passive")
    public final CamelScheme.Builder passive(boolean passive) {
      this.passive = passive;
      optBits |= OPT_BIT_PASSIVE;
      return (CamelScheme.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelScheme ImmutableCamelScheme}.
     * @return An immutable instance of CamelScheme
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelScheme build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelScheme(this);
    }

    private boolean httpIsSet() {
      return (optBits & OPT_BIT_HTTP) != 0;
    }

    private boolean passiveIsSet() {
      return (optBits & OPT_BIT_PASSIVE) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build CamelScheme, some of required attributes are not set " + attributes;
    }
  }
}
