package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelArtifact}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelArtifact.Builder()}.
 */
@Generated(from = "CamelArtifact", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelArtifact implements CamelArtifact {
  private final String groupId;
  private final String artifactId;
  private final String version;
  private final Set<CamelScheme> schemes;
  private final Set<String> languages;
  private final Set<String> dataformats;
  private final Set<Artifact> dependencies;
  private final Set<Artifact> exclusions;
  private final Set<String> javaTypes;

  private ImmutableCamelArtifact(ImmutableCamelArtifact.Builder builder) {
    this.groupId = builder.groupId;
    this.artifactId = builder.artifactId;
    this.version = builder.version;
    if (builder.schemesIsSet()) {
      initShim.schemes(createUnmodifiableSet(builder.schemes));
    }
    if (builder.languagesIsSet()) {
      initShim.languages(createUnmodifiableSet(builder.languages));
    }
    if (builder.dataformatsIsSet()) {
      initShim.dataformats(createUnmodifiableSet(builder.dataformats));
    }
    if (builder.dependenciesIsSet()) {
      initShim.dependencies(createUnmodifiableSet(builder.dependencies));
    }
    if (builder.exclusionsIsSet()) {
      initShim.exclusions(createUnmodifiableSet(builder.exclusions));
    }
    if (builder.javaTypesIsSet()) {
      initShim.javaTypes(createUnmodifiableSet(builder.javaTypes));
    }
    this.schemes = initShim.getSchemes();
    this.languages = initShim.getLanguages();
    this.dataformats = initShim.getDataformats();
    this.dependencies = initShim.getDependencies();
    this.exclusions = initShim.getExclusions();
    this.javaTypes = initShim.getJavaTypes();
    this.initShim = null;
  }

  private ImmutableCamelArtifact(
      String groupId,
      String artifactId,
      String version,
      Set<CamelScheme> schemes,
      Set<String> languages,
      Set<String> dataformats,
      Set<Artifact> dependencies,
      Set<Artifact> exclusions,
      Set<String> javaTypes) {
    this.groupId = groupId;
    this.artifactId = artifactId;
    this.version = version;
    this.schemes = schemes;
    this.languages = languages;
    this.dataformats = dataformats;
    this.dependencies = dependencies;
    this.exclusions = exclusions;
    this.javaTypes = javaTypes;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "CamelArtifact", generator = "Immutables")
  private final class InitShim {
    private byte schemesBuildStage = STAGE_UNINITIALIZED;
    private Set<CamelScheme> schemes;

    Set<CamelScheme> getSchemes() {
      if (schemesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (schemesBuildStage == STAGE_UNINITIALIZED) {
        schemesBuildStage = STAGE_INITIALIZING;
        this.schemes = createUnmodifiableSet(createSafeList(getSchemesInitialize(), true, false));
        schemesBuildStage = STAGE_INITIALIZED;
      }
      return this.schemes;
    }

    void schemes(Set<CamelScheme> schemes) {
      this.schemes = schemes;
      schemesBuildStage = STAGE_INITIALIZED;
    }

    private byte languagesBuildStage = STAGE_UNINITIALIZED;
    private Set<String> languages;

    Set<String> getLanguages() {
      if (languagesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (languagesBuildStage == STAGE_UNINITIALIZED) {
        languagesBuildStage = STAGE_INITIALIZING;
        this.languages = createUnmodifiableSet(createSafeList(getLanguagesInitialize(), true, false));
        languagesBuildStage = STAGE_INITIALIZED;
      }
      return this.languages;
    }

    void languages(Set<String> languages) {
      this.languages = languages;
      languagesBuildStage = STAGE_INITIALIZED;
    }

    private byte dataformatsBuildStage = STAGE_UNINITIALIZED;
    private Set<String> dataformats;

    Set<String> getDataformats() {
      if (dataformatsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dataformatsBuildStage == STAGE_UNINITIALIZED) {
        dataformatsBuildStage = STAGE_INITIALIZING;
        this.dataformats = createUnmodifiableSet(createSafeList(getDataformatsInitialize(), true, false));
        dataformatsBuildStage = STAGE_INITIALIZED;
      }
      return this.dataformats;
    }

    void dataformats(Set<String> dataformats) {
      this.dataformats = dataformats;
      dataformatsBuildStage = STAGE_INITIALIZED;
    }

    private byte dependenciesBuildStage = STAGE_UNINITIALIZED;
    private Set<Artifact> dependencies;

    Set<Artifact> getDependencies() {
      if (dependenciesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (dependenciesBuildStage == STAGE_UNINITIALIZED) {
        dependenciesBuildStage = STAGE_INITIALIZING;
        this.dependencies = createUnmodifiableSet(createSafeList(getDependenciesInitialize(), true, false));
        dependenciesBuildStage = STAGE_INITIALIZED;
      }
      return this.dependencies;
    }

    void dependencies(Set<Artifact> dependencies) {
      this.dependencies = dependencies;
      dependenciesBuildStage = STAGE_INITIALIZED;
    }

    private byte exclusionsBuildStage = STAGE_UNINITIALIZED;
    private Set<Artifact> exclusions;

    Set<Artifact> getExclusions() {
      if (exclusionsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (exclusionsBuildStage == STAGE_UNINITIALIZED) {
        exclusionsBuildStage = STAGE_INITIALIZING;
        this.exclusions = createUnmodifiableSet(createSafeList(getExclusionsInitialize(), true, false));
        exclusionsBuildStage = STAGE_INITIALIZED;
      }
      return this.exclusions;
    }

    void exclusions(Set<Artifact> exclusions) {
      this.exclusions = exclusions;
      exclusionsBuildStage = STAGE_INITIALIZED;
    }

    private byte javaTypesBuildStage = STAGE_UNINITIALIZED;
    private Set<String> javaTypes;

    Set<String> getJavaTypes() {
      if (javaTypesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (javaTypesBuildStage == STAGE_UNINITIALIZED) {
        javaTypesBuildStage = STAGE_INITIALIZING;
        this.javaTypes = createUnmodifiableSet(createSafeList(getJavaTypesInitialize(), true, false));
        javaTypesBuildStage = STAGE_INITIALIZED;
      }
      return this.javaTypes;
    }

    void javaTypes(Set<String> javaTypes) {
      this.javaTypes = javaTypes;
      javaTypesBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (schemesBuildStage == STAGE_INITIALIZING) attributes.add("schemes");
      if (languagesBuildStage == STAGE_INITIALIZING) attributes.add("languages");
      if (dataformatsBuildStage == STAGE_INITIALIZING) attributes.add("dataformats");
      if (dependenciesBuildStage == STAGE_INITIALIZING) attributes.add("dependencies");
      if (exclusionsBuildStage == STAGE_INITIALIZING) attributes.add("exclusions");
      if (javaTypesBuildStage == STAGE_INITIALIZING) attributes.add("javaTypes");
      return "Cannot build CamelArtifact, attribute initializers form cycle " + attributes;
    }
  }

  private Set<CamelScheme> getSchemesInitialize() {
    return CamelArtifact.super.getSchemes();
  }

  private Set<String> getLanguagesInitialize() {
    return CamelArtifact.super.getLanguages();
  }

  private Set<String> getDataformatsInitialize() {
    return CamelArtifact.super.getDataformats();
  }

  private Set<Artifact> getDependenciesInitialize() {
    return CamelArtifact.super.getDependencies();
  }

  private Set<Artifact> getExclusionsInitialize() {
    return CamelArtifact.super.getExclusions();
  }

  private Set<String> getJavaTypesInitialize() {
    return CamelArtifact.super.getJavaTypes();
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * @return The value of the {@code artifactId} attribute
   */
  @JsonProperty("artifactId")
  @Override
  public String getArtifactId() {
    return artifactId;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public Optional<String> getVersion() {
    return Optional.ofNullable(version);
  }

  /**
   * @return The value of the {@code schemes} attribute
   */
  @JsonProperty("schemes")
  @Override
  public Set<CamelScheme> getSchemes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSchemes()
        : this.schemes;
  }

  /**
   * @return The value of the {@code languages} attribute
   */
  @JsonProperty("languages")
  @Override
  public Set<String> getLanguages() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getLanguages()
        : this.languages;
  }

  /**
   * @return The value of the {@code dataformats} attribute
   */
  @JsonProperty("dataformats")
  @Override
  public Set<String> getDataformats() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDataformats()
        : this.dataformats;
  }

  /**
   * @return The value of the {@code dependencies} attribute
   */
  @JsonProperty("dependencies")
  @Override
  public Set<Artifact> getDependencies() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDependencies()
        : this.dependencies;
  }

  /**
   * @return The value of the {@code exclusions} attribute
   */
  @JsonProperty("exclusions")
  @Override
  public Set<Artifact> getExclusions() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExclusions()
        : this.exclusions;
  }

  /**
   * @return The value of the {@code javaTypes} attribute
   */
  @JsonProperty("javaTypes")
  @Override
  public Set<String> getJavaTypes() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getJavaTypes()
        : this.javaTypes;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelArtifact#getGroupId() groupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelArtifact withGroupId(String value) {
    String newValue = Objects.requireNonNull(value, "groupId");
    if (this.groupId.equals(newValue)) return this;
    return new ImmutableCamelArtifact(
        newValue,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelArtifact#getArtifactId() artifactId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for artifactId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelArtifact withArtifactId(String value) {
    String newValue = Objects.requireNonNull(value, "artifactId");
    if (this.artifactId.equals(newValue)) return this;
    return new ImmutableCamelArtifact(
        this.groupId,
        newValue,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link CamelArtifact#getVersion() version} attribute.
   * @param value The value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (Objects.equals(this.version, newValue)) return this;
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        newValue,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link CamelArtifact#getVersion() version} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for version
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withVersion(Optional<String> optional) {
    String value = optional.orElse(null);
    if (Objects.equals(this.version, value)) return this;
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        value,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getSchemes() schemes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withSchemes(CamelScheme... elements) {
    Set<CamelScheme> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        newValue,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getSchemes() schemes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of schemes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withSchemes(Iterable<? extends CamelScheme> elements) {
    if (this.schemes == elements) return this;
    Set<CamelScheme> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        newValue,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getLanguages() languages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withLanguages(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        newValue,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getLanguages() languages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of languages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withLanguages(Iterable<String> elements) {
    if (this.languages == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        newValue,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getDataformats() dataformats}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withDataformats(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        newValue,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getDataformats() dataformats}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dataformats elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withDataformats(Iterable<String> elements) {
    if (this.dataformats == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        newValue,
        this.dependencies,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getDependencies() dependencies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withDependencies(Artifact... elements) {
    Set<Artifact> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        newValue,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getDependencies() dependencies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dependencies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withDependencies(Iterable<? extends Artifact> elements) {
    if (this.dependencies == elements) return this;
    Set<Artifact> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        newValue,
        this.exclusions,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getExclusions() exclusions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withExclusions(Artifact... elements) {
    Set<Artifact> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        newValue,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getExclusions() exclusions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of exclusions elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withExclusions(Iterable<? extends Artifact> elements) {
    if (this.exclusions == elements) return this;
    Set<Artifact> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        newValue,
        this.javaTypes);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getJavaTypes() javaTypes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withJavaTypes(String... elements) {
    Set<String> newValue = createUnmodifiableSet(createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelArtifact#getJavaTypes() javaTypes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of javaTypes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelArtifact withJavaTypes(Iterable<String> elements) {
    if (this.javaTypes == elements) return this;
    Set<String> newValue = createUnmodifiableSet(createSafeList(elements, true, false));
    return new ImmutableCamelArtifact(
        this.groupId,
        this.artifactId,
        this.version,
        this.schemes,
        this.languages,
        this.dataformats,
        this.dependencies,
        this.exclusions,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelArtifact} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelArtifact
        && equalTo((ImmutableCamelArtifact) another);
  }

  private boolean equalTo(ImmutableCamelArtifact another) {
    return groupId.equals(another.groupId)
        && artifactId.equals(another.artifactId)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code groupId}, {@code artifactId}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + artifactId.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code CamelArtifact} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("CamelArtifact{");
    builder.append("groupId=").append(groupId);
    builder.append(", ");
    builder.append("artifactId=").append(artifactId);
    if (version != null) {
      builder.append(", ");
      builder.append("version=").append(version);
    }
    return builder.append("}").toString();
  }

  /**
   * Creates an immutable copy of a {@link CamelArtifact} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelArtifact instance
   */
  public static ImmutableCamelArtifact copyOf(CamelArtifact instance) {
    if (instance instanceof ImmutableCamelArtifact) {
      return (ImmutableCamelArtifact) instance;
    }
    return new CamelArtifact.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelArtifact ImmutableCamelArtifact}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelArtifact", generator = "Immutables")
  @JsonPropertyOrder({"groupId", "artifactId", "version"})
  public static class Builder {
    private static final long INIT_BIT_GROUP_ID = 0x1L;
    private static final long INIT_BIT_ARTIFACT_ID = 0x2L;
    private static final long OPT_BIT_SCHEMES = 0x1L;
    private static final long OPT_BIT_LANGUAGES = 0x2L;
    private static final long OPT_BIT_DATAFORMATS = 0x4L;
    private static final long OPT_BIT_DEPENDENCIES = 0x8L;
    private static final long OPT_BIT_EXCLUSIONS = 0x10L;
    private static final long OPT_BIT_JAVA_TYPES = 0x20L;
    private long initBits = 0x3L;
    private long optBits;

    private String groupId;
    private String artifactId;
    private String version;
    private List<CamelScheme> schemes = new ArrayList<CamelScheme>();
    private List<String> languages = new ArrayList<String>();
    private List<String> dataformats = new ArrayList<String>();
    private List<Artifact> dependencies = new ArrayList<Artifact>();
    private List<Artifact> exclusions = new ArrayList<Artifact>();
    private List<String> javaTypes = new ArrayList<String>();

    /**
     * Creates a builder for {@link ImmutableCamelArtifact ImmutableCamelArtifact} instances.
     * <pre>
     * new CamelArtifact.Builder()
     *    .groupId(String) // required {@link CamelArtifact#getGroupId() groupId}
     *    .artifactId(String) // required {@link CamelArtifact#getArtifactId() artifactId}
     *    .version(String) // optional {@link CamelArtifact#getVersion() version}
     *    .addScheme|addAllSchemes(org.apache.camel.k.tooling.maven.model.CamelScheme) // {@link CamelArtifact#getSchemes() schemes} elements
     *    .addLanguage|addAllLanguages(String) // {@link CamelArtifact#getLanguages() languages} elements
     *    .addDataformat|addAllDataformats(String) // {@link CamelArtifact#getDataformats() dataformats} elements
     *    .addDependency|addAllDependencies(org.apache.camel.k.tooling.maven.model.Artifact) // {@link CamelArtifact#getDependencies() dependencies} elements
     *    .addExclusion|addAllExclusions(org.apache.camel.k.tooling.maven.model.Artifact) // {@link CamelArtifact#getExclusions() exclusions} elements
     *    .addJavaType|addAllJavaTypes(String) // {@link CamelArtifact#getJavaTypes() javaTypes} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelArtifact.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelArtifact.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.CamelArtifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder from(CamelArtifact instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (CamelArtifact.Builder) this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.apache.camel.k.tooling.maven.model.Artifact} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder from(Artifact instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return (CamelArtifact.Builder) this;
    }

    private void from(Object object) {
      if (object instanceof CamelArtifact) {
        CamelArtifact instance = (CamelArtifact) object;
        addAllJavaTypes(instance.getJavaTypes());
        addAllExclusions(instance.getExclusions());
        addAllSchemes(instance.getSchemes());
        addAllLanguages(instance.getLanguages());
        addAllDataformats(instance.getDataformats());
        addAllDependencies(instance.getDependencies());
      }
      if (object instanceof Artifact) {
        Artifact instance = (Artifact) object;
        Optional<String> versionOptional = instance.getVersion();
        if (versionOptional.isPresent()) {
          version(versionOptional);
        }
        artifactId(instance.getArtifactId());
        groupId(instance.getGroupId());
      }
    }

    /**
     * Initializes the value for the {@link CamelArtifact#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final CamelArtifact.Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelArtifact#getArtifactId() artifactId} attribute.
     * @param artifactId The value for artifactId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("artifactId")
    public final CamelArtifact.Builder artifactId(String artifactId) {
      this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
      initBits &= ~INIT_BIT_ARTIFACT_ID;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Initializes the optional value {@link CamelArtifact#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for chained invocation
     */
    public final CamelArtifact.Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      return (CamelArtifact.Builder) this;
    }

    /**
     * Initializes the optional value {@link CamelArtifact#getVersion() version} to version.
     * @param version The value for version
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final CamelArtifact.Builder version(Optional<String> version) {
      this.version = version.orElse(null);
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds one element to {@link CamelArtifact#getSchemes() schemes} set.
     * @param element A schemes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addScheme(CamelScheme element) {
      this.schemes.add(Objects.requireNonNull(element, "schemes element"));
      optBits |= OPT_BIT_SCHEMES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds elements to {@link CamelArtifact#getSchemes() schemes} set.
     * @param elements An array of schemes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addSchemes(CamelScheme... elements) {
      for (CamelScheme element : elements) {
        this.schemes.add(Objects.requireNonNull(element, "schemes element"));
      }
      optBits |= OPT_BIT_SCHEMES;
      return (CamelArtifact.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelArtifact#getSchemes() schemes} set.
     * @param elements An iterable of schemes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("schemes")
    public final CamelArtifact.Builder schemes(Iterable<? extends CamelScheme> elements) {
      this.schemes.clear();
      return addAllSchemes(elements);
    }

    /**
     * Adds elements to {@link CamelArtifact#getSchemes() schemes} set.
     * @param elements An iterable of schemes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addAllSchemes(Iterable<? extends CamelScheme> elements) {
      for (CamelScheme element : elements) {
        this.schemes.add(Objects.requireNonNull(element, "schemes element"));
      }
      optBits |= OPT_BIT_SCHEMES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds one element to {@link CamelArtifact#getLanguages() languages} set.
     * @param element A languages element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addLanguage(String element) {
      this.languages.add(Objects.requireNonNull(element, "languages element"));
      optBits |= OPT_BIT_LANGUAGES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds elements to {@link CamelArtifact#getLanguages() languages} set.
     * @param elements An array of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addLanguages(String... elements) {
      for (String element : elements) {
        this.languages.add(Objects.requireNonNull(element, "languages element"));
      }
      optBits |= OPT_BIT_LANGUAGES;
      return (CamelArtifact.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelArtifact#getLanguages() languages} set.
     * @param elements An iterable of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("languages")
    public final CamelArtifact.Builder languages(Iterable<String> elements) {
      this.languages.clear();
      return addAllLanguages(elements);
    }

    /**
     * Adds elements to {@link CamelArtifact#getLanguages() languages} set.
     * @param elements An iterable of languages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addAllLanguages(Iterable<String> elements) {
      for (String element : elements) {
        this.languages.add(Objects.requireNonNull(element, "languages element"));
      }
      optBits |= OPT_BIT_LANGUAGES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds one element to {@link CamelArtifact#getDataformats() dataformats} set.
     * @param element A dataformats element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addDataformat(String element) {
      this.dataformats.add(Objects.requireNonNull(element, "dataformats element"));
      optBits |= OPT_BIT_DATAFORMATS;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds elements to {@link CamelArtifact#getDataformats() dataformats} set.
     * @param elements An array of dataformats elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addDataformats(String... elements) {
      for (String element : elements) {
        this.dataformats.add(Objects.requireNonNull(element, "dataformats element"));
      }
      optBits |= OPT_BIT_DATAFORMATS;
      return (CamelArtifact.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelArtifact#getDataformats() dataformats} set.
     * @param elements An iterable of dataformats elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dataformats")
    public final CamelArtifact.Builder dataformats(Iterable<String> elements) {
      this.dataformats.clear();
      return addAllDataformats(elements);
    }

    /**
     * Adds elements to {@link CamelArtifact#getDataformats() dataformats} set.
     * @param elements An iterable of dataformats elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addAllDataformats(Iterable<String> elements) {
      for (String element : elements) {
        this.dataformats.add(Objects.requireNonNull(element, "dataformats element"));
      }
      optBits |= OPT_BIT_DATAFORMATS;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds one element to {@link CamelArtifact#getDependencies() dependencies} set.
     * @param element A dependencies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addDependency(Artifact element) {
      this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds elements to {@link CamelArtifact#getDependencies() dependencies} set.
     * @param elements An array of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addDependencies(Artifact... elements) {
      for (Artifact element : elements) {
        this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
      }
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelArtifact.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelArtifact#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dependencies")
    public final CamelArtifact.Builder dependencies(Iterable<? extends Artifact> elements) {
      this.dependencies.clear();
      return addAllDependencies(elements);
    }

    /**
     * Adds elements to {@link CamelArtifact#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
      for (Artifact element : elements) {
        this.dependencies.add(Objects.requireNonNull(element, "dependencies element"));
      }
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds one element to {@link CamelArtifact#getExclusions() exclusions} set.
     * @param element A exclusions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addExclusion(Artifact element) {
      this.exclusions.add(Objects.requireNonNull(element, "exclusions element"));
      optBits |= OPT_BIT_EXCLUSIONS;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds elements to {@link CamelArtifact#getExclusions() exclusions} set.
     * @param elements An array of exclusions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addExclusions(Artifact... elements) {
      for (Artifact element : elements) {
        this.exclusions.add(Objects.requireNonNull(element, "exclusions element"));
      }
      optBits |= OPT_BIT_EXCLUSIONS;
      return (CamelArtifact.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelArtifact#getExclusions() exclusions} set.
     * @param elements An iterable of exclusions elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("exclusions")
    public final CamelArtifact.Builder exclusions(Iterable<? extends Artifact> elements) {
      this.exclusions.clear();
      return addAllExclusions(elements);
    }

    /**
     * Adds elements to {@link CamelArtifact#getExclusions() exclusions} set.
     * @param elements An iterable of exclusions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addAllExclusions(Iterable<? extends Artifact> elements) {
      for (Artifact element : elements) {
        this.exclusions.add(Objects.requireNonNull(element, "exclusions element"));
      }
      optBits |= OPT_BIT_EXCLUSIONS;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds one element to {@link CamelArtifact#getJavaTypes() javaTypes} set.
     * @param element A javaTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addJavaType(String element) {
      this.javaTypes.add(Objects.requireNonNull(element, "javaTypes element"));
      optBits |= OPT_BIT_JAVA_TYPES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Adds elements to {@link CamelArtifact#getJavaTypes() javaTypes} set.
     * @param elements An array of javaTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addJavaTypes(String... elements) {
      for (String element : elements) {
        this.javaTypes.add(Objects.requireNonNull(element, "javaTypes element"));
      }
      optBits |= OPT_BIT_JAVA_TYPES;
      return (CamelArtifact.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelArtifact#getJavaTypes() javaTypes} set.
     * @param elements An iterable of javaTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("javaTypes")
    public final CamelArtifact.Builder javaTypes(Iterable<String> elements) {
      this.javaTypes.clear();
      return addAllJavaTypes(elements);
    }

    /**
     * Adds elements to {@link CamelArtifact#getJavaTypes() javaTypes} set.
     * @param elements An iterable of javaTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelArtifact.Builder addAllJavaTypes(Iterable<String> elements) {
      for (String element : elements) {
        this.javaTypes.add(Objects.requireNonNull(element, "javaTypes element"));
      }
      optBits |= OPT_BIT_JAVA_TYPES;
      return (CamelArtifact.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelArtifact ImmutableCamelArtifact}.
     * @return An immutable instance of CamelArtifact
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelArtifact build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelArtifact(this);
    }

    private boolean schemesIsSet() {
      return (optBits & OPT_BIT_SCHEMES) != 0;
    }

    private boolean languagesIsSet() {
      return (optBits & OPT_BIT_LANGUAGES) != 0;
    }

    private boolean dataformatsIsSet() {
      return (optBits & OPT_BIT_DATAFORMATS) != 0;
    }

    private boolean dependenciesIsSet() {
      return (optBits & OPT_BIT_DEPENDENCIES) != 0;
    }

    private boolean exclusionsIsSet() {
      return (optBits & OPT_BIT_EXCLUSIONS) != 0;
    }

    private boolean javaTypesIsSet() {
      return (optBits & OPT_BIT_JAVA_TYPES) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ARTIFACT_ID) != 0) attributes.add("artifactId");
      return "Cannot build CamelArtifact, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  /** Unmodifiable set constructed from list to avoid rehashing. */
  private static <T> Set<T> createUnmodifiableSet(List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default:
      Set<T> set = new LinkedHashSet<>(list.size());
      set.addAll(list);
      return Collections.unmodifiableSet(set);
    }
  }
}
