/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.DefaultRuntimeProvider;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.quarkus.QuarkusRuntimeProvider;
import org.apache.camel.impl.engine.AbstractCamelContext;
import org.apache.camel.k.tooling.maven.GenerateSupport;
import org.apache.camel.k.tooling.maven.model.CamelCapability;
import org.apache.camel.k.tooling.maven.model.CatalogProcessor;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalog;
import org.apache.camel.k.tooling.maven.model.crd.CamelCatalogSpec;
import org.apache.camel.k.tooling.maven.model.crd.ImmutableCamelCatalog;
import org.apache.camel.k.tooling.maven.model.crd.RuntimeSpec;
import org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta;
import org.apache.camel.quarkus.core.FastCamelContext;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="generate-catalog", defaultPhase=LifecyclePhase.GENERATE_RESOURCES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateCatalogMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="catalog.path", defaultValue="${project.build.directory}")
    private String outputPath;
    @Parameter(property="catalog.file", defaultValue="camel-catalog-${runtime.version}.yaml")
    private String outputFile;
    @Parameter(property="catalog.runtime", defaultValue="main")
    private String runtime;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path output = Paths.get(this.outputPath, this.outputFile);
        try {
            if (Files.notExists(output.getParent(), new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
            if (Files.exists(output, new LinkOption[0])) {
                Files.delete(output);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating camel catalog", (Exception)e);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String runtimeVersion = GenerateCatalogMojo.getVersion(((Object)((Object)this)).getClass(), "/META-INF/maven/org.apache.camel.k/camel-k-maven-plugin/pom.properties");
        String catalogName = String.format("camel-catalog-%s-%s", runtimeVersion.toLowerCase(), this.runtime);
        try {
            ServiceLoader<CatalogProcessor> processors = ServiceLoader.load(CatalogProcessor.class);
            Comparator<CatalogProcessor> comparator = Comparator.comparingInt(CatalogProcessor::getOrder);
            RuntimeSpec.Builder runtimeSpec = new RuntimeSpec.Builder().version(runtimeVersion).provider(this.runtime);
            GenerateCatalogMojo.getVersion(AbstractCamelContext.class, "org.apache.camel", "camel-base", version -> runtimeSpec.putMetadata("camel.version", (String)version));
            GenerateCatalogMojo.getVersion(FastCamelContext.class, "io.quarkus", "quarkus-core", version -> runtimeSpec.putMetadata("quarkus.version", (String)version));
            GenerateCatalogMojo.getVersion(QuarkusRuntimeProvider.class, "org.apache.camel.quarkus", "camel-quarkus-catalog", version -> runtimeSpec.putMetadata("camel-quarkus.version", (String)version));
            switch (this.runtime) {
                case "main": {
                    catalog.setRuntimeProvider((RuntimeProvider)new DefaultRuntimeProvider());
                    runtimeSpec.applicationClass("org.apache.camel.k.main.Application");
                    runtimeSpec.addDependency("org.apache.camel.k", "camel-k-runtime-main");
                    runtimeSpec.putCapability("cron", CamelCapability.forArtifact("org.apache.camel.k", "camel-k-runtime-cron"));
                    runtimeSpec.putCapability("health", CamelCapability.forArtifact("org.apache.camel.k", "camel-k-runtime-health"));
                    runtimeSpec.putCapability("platform-http", CamelCapability.forArtifact("org.apache.camel.k", "camel-k-runtime-http"));
                    runtimeSpec.putCapability("rest", new CamelCapability.Builder().addDependency("org.apache.camel", "camel-rest").addDependency("org.apache.camel.k", "camel-k-runtime-http").build());
                    runtimeSpec.putCapability("circuit-breaker", CamelCapability.forArtifact("org.apache.camel", "camel-microprofile-fault-tolerance"));
                    runtimeSpec.putCapability("tracing", CamelCapability.forArtifact("org.apache.camel.k", "camel-k-runtime-tracing"));
                    break;
                }
                case "quarkus": {
                    catalog.setRuntimeProvider((RuntimeProvider)new QuarkusRuntimeProvider());
                    runtimeSpec.applicationClass("io.quarkus.runner.GeneratedMain");
                    runtimeSpec.addDependency("org.apache.camel.k", "camel-k-runtime-quarkus");
                    runtimeSpec.putCapability("cron", CamelCapability.forArtifact("org.apache.camel.k", "camel-k-quarkus-cron"));
                    runtimeSpec.putCapability("health", CamelCapability.forArtifact("org.apache.camel.quarkus", "camel-quarkus-microprofile-health"));
                    runtimeSpec.putCapability("platform-http", CamelCapability.forArtifact("org.apache.camel.quarkus", "camel-quarkus-platform-http"));
                    runtimeSpec.putCapability("rest", new CamelCapability.Builder().addDependency("org.apache.camel.quarkus", "camel-quarkus-rest").addDependency("org.apache.camel.quarkus", "camel-quarkus-platform-http").build());
                    runtimeSpec.putCapability("circuit-breaker", CamelCapability.forArtifact("org.apache.camel.quarkus", "camel-quarkus-microprofile-fault-tolerance"));
                    runtimeSpec.putCapability("tracing", CamelCapability.forArtifact("org.apache.camel.quarkus", "camel-quarkus-opentracing"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("catalog.runtime parameter value [" + this.runtime + "] is not supported!");
                }
            }
            CamelCatalogSpec.Builder catalogSpec = new CamelCatalogSpec.Builder().runtime(runtimeSpec.build());
            StreamSupport.stream(processors.spliterator(), false).sorted(comparator).filter(arg_0 -> GenerateCatalogMojo.lambda$execute$3((CamelCatalog)catalog, arg_0)).forEach(arg_0 -> this.lambda$execute$4((CamelCatalog)catalog, catalogSpec, arg_0));
            ObjectMeta.Builder metadata = new ObjectMeta.Builder().name(catalogName).putLabels("app", "camel-k").putLabels("camel.apache.org/catalog.version", catalog.getCatalogVersion()).putLabels("camel.apache.org/catalog.loader.version", catalog.getLoadedVersion()).putLabels("camel.apache.org/runtime.version", runtimeVersion).putLabels("camel.apache.org/runtime.provider", this.runtime);
            ImmutableCamelCatalog cr = new CamelCatalog.Builder().metadata(metadata.build()).spec(catalogSpec.build()).build();
            try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
                YAMLFactory factory = new YAMLFactory().configure(YAMLGenerator.Feature.MINIMIZE_QUOTES, true).configure(YAMLGenerator.Feature.ALWAYS_QUOTE_NUMBERS_AS_STRINGS, true).configure(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID, false).configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
                writer.write(GenerateSupport.getResourceAsString("/catalog-license.txt"));
                this.getLog().info((CharSequence)("Writing catalog file to: " + output));
                ObjectMapper mapper = new ObjectMapper((JsonFactory)factory);
                mapper.registerModule((Module)new Jdk8Module());
                mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
                mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
                mapper.writeValue((Writer)writer, (Object)cr);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating catalog", (Exception)e);
        }
    }

    private static void getVersion(Class<?> clazz, String path, Consumer<String> consumer) {
        consumer.accept(GenerateCatalogMojo.getVersion(clazz, path));
    }

    private static void getVersion(Class<?> clazz, String groupId, String artifactId, Consumer<String> consumer) {
        GenerateCatalogMojo.getVersion(clazz, String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId), consumer);
    }

    private static synchronized String getVersion(Class<?> clazz, String groupId, String artifactId) {
        return GenerateCatalogMojo.getVersion(clazz, String.format("/META-INF/maven/%s/%s/pom.properties", groupId, artifactId));
    }

    private static synchronized String getVersion(Class<?> clazz, String path) {
        Package aPackage;
        String version = null;
        try (InputStream is2 = clazz.getResourceAsStream(path);){
            if (is2 != null) {
                Properties p = new Properties();
                p.load(is2);
                version = p.getProperty("version", "");
            }
        }
        catch (Exception is2) {
            // empty catch block
        }
        if (version == null && (aPackage = clazz.getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version == null) {
            throw new IllegalStateException("Unable to determine runtime version");
        }
        return version;
    }

    private /* synthetic */ void lambda$execute$4(CamelCatalog catalog, CamelCatalogSpec.Builder catalogSpec, CatalogProcessor p) {
        this.getLog().info((CharSequence)("Executing processor: " + p.getClass().getName()));
        p.process(this.project, catalog, catalogSpec);
    }

    private static /* synthetic */ boolean lambda$execute$3(CamelCatalog catalog, CatalogProcessor p) {
        return p.accepts(catalog);
    }
}

