package org.apache.camel.k.tooling.maven.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.collect.ImmutableSet;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelCapability}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelCapability.Builder()}.
 */
@Generated(from = "CamelCapability", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelCapability implements CamelCapability {
  private final ImmutableSet<Artifact> dependencies;

  private ImmutableCamelCapability(ImmutableCamelCapability.Builder builder) {
    this.dependencies = builder.dependenciesIsSet()
        ? builder.dependencies.build()
        : ImmutableSet.copyOf(CamelCapability.super.getDependencies());
  }

  private ImmutableCamelCapability(
      ImmutableSet<Artifact> dependencies) {
    this.dependencies = dependencies;
  }

  /**
   * @return The value of the {@code dependencies} attribute
   */
  @JsonProperty("dependencies")
  @Override
  public ImmutableSet<Artifact> getDependencies() {
    return dependencies;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelCapability#getDependencies() dependencies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelCapability withDependencies(Artifact... elements) {
    ImmutableSet<Artifact> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCamelCapability(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CamelCapability#getDependencies() dependencies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of dependencies elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCamelCapability withDependencies(Iterable<? extends Artifact> elements) {
    if (this.dependencies == elements) return this;
    ImmutableSet<Artifact> newValue = ImmutableSet.copyOf(elements);
    return new ImmutableCamelCapability(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelCapability} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelCapability
        && equalTo((ImmutableCamelCapability) another);
  }

  @SuppressWarnings("MethodCanBeStatic")
  private boolean equalTo(ImmutableCamelCapability another) {
    return true;
  }

  /**
   * Returns a constant hash code value.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    return 0;
  }

  /**
   * Prints the immutable value {@code CamelCapability}.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CamelCapability{}";
  }

  /**
   * Creates an immutable copy of a {@link CamelCapability} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelCapability instance
   */
  public static ImmutableCamelCapability copyOf(CamelCapability instance) {
    if (instance instanceof ImmutableCamelCapability) {
      return (ImmutableCamelCapability) instance;
    }
    return new CamelCapability.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelCapability ImmutableCamelCapability}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelCapability", generator = "Immutables")
  @JsonPropertyOrder({"groupId", "artifactId", "version"})
  public static class Builder {
    private static final long OPT_BIT_DEPENDENCIES = 0x1L;
    private long optBits;

    private ImmutableSet.Builder<Artifact> dependencies = ImmutableSet.builder();

    /**
     * Creates a builder for {@link ImmutableCamelCapability ImmutableCamelCapability} instances.
     * <pre>
     * new CamelCapability.Builder()
     *    .addDependency|addAllDependencies(org.apache.camel.k.tooling.maven.model.Artifact) // {@link CamelCapability#getDependencies() dependencies} elements
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelCapability.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelCapability.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CamelCapability} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCapability.Builder from(CamelCapability instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDependencies(instance.getDependencies());
      return (CamelCapability.Builder) this;
    }

    /**
     * Adds one element to {@link CamelCapability#getDependencies() dependencies} set.
     * @param element A dependencies element
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCapability.Builder addDependency(Artifact element) {
      this.dependencies.add(element);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelCapability.Builder) this;
    }

    /**
     * Adds elements to {@link CamelCapability#getDependencies() dependencies} set.
     * @param elements An array of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCapability.Builder addDependencies(Artifact... elements) {
      this.dependencies.add(elements);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelCapability.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link CamelCapability#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("dependencies")
    public final CamelCapability.Builder dependencies(Iterable<? extends Artifact> elements) {
      this.dependencies = ImmutableSet.builder();
      return addAllDependencies(elements);
    }

    /**
     * Adds elements to {@link CamelCapability#getDependencies() dependencies} set.
     * @param elements An iterable of dependencies elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCapability.Builder addAllDependencies(Iterable<? extends Artifact> elements) {
      this.dependencies.addAll(elements);
      optBits |= OPT_BIT_DEPENDENCIES;
      return (CamelCapability.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelCapability ImmutableCamelCapability}.
     * @return An immutable instance of CamelCapability
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelCapability build() {
      return new ImmutableCamelCapability(this);
    }

    private boolean dependenciesIsSet() {
      return (optBits & OPT_BIT_DEPENDENCIES) != 0;
    }
  }
}
