/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.camel.k.tooling.maven.model.CamelCapability;
import org.apache.camel.k.tooling.maven.model.MavenArtifact;
import org.apache.camel.k.tooling.maven.model.crd.ImmutableRuntimeSpec;
import org.immutables.value.Value;

@JsonDeserialize(builder=Builder.class)
@JsonPropertyOrder(value={"version", "runtimeVersion", "artifacts"})
@Value.Immutable
@Value.Style(depluralize=true)
public interface RuntimeSpec {
    public String getVersion();

    public String getProvider();

    public String getApplicationClass();

    @Value.Default
    default public Map<String, String> getMetadata() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public Set<MavenArtifact> getDependencies() {
        return Collections.emptySet();
    }

    @Value.Default
    default public Map<String, CamelCapability> getCapabilities() {
        return Collections.emptyMap();
    }

    public static class Builder
    extends ImmutableRuntimeSpec.Builder {
        public Builder addDependency(String groupId, String artifactId) {
            this.addDependencies(MavenArtifact.from(groupId, artifactId));
            return this;
        }
    }
}

