/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;

public abstract class GenerateYamlSupport
extends AbstractMojo {
    public static final DotName EXPRESSION_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.language.ExpressionDefinition");
    public static final DotName DATAFORMAT_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.DataFormatDefinition");
    public static final DotName XMLROOTELEMENT_ANNOTATION_CLASS = DotName.createSimple((String)"javax.xml.bind.annotation.XmlRootElement");
    public static final DotName YAML_STEP_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.k.loader.yaml.model.Step$Definition");
    public static final DotName YAML_STEP_PARSER_ANNOTATION = DotName.createSimple((String)"org.apache.camel.k.annotation.yaml.YAMLStepParser");
    public static final DotName YAML_STEP_DEFINITION_ANNOTATION = DotName.createSimple((String)"org.apache.camel.k.annotation.yaml.YAMLNodeDefinition");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camel")
    protected String output;

    protected Map<String, Class<?>> definitions(DotName type) {
        ClassLoader cl = this.getClassLoader();
        HashMap definitions = new HashMap();
        IndexView view = GenerateYamlSupport.getCompositeIndexer(cl);
        for (ClassInfo ci : view.getAllKnownSubclasses(type)) {
            AnnotationValue name;
            AnnotationInstance instance = ci.classAnnotation(XMLROOTELEMENT_ANNOTATION_CLASS);
            if (instance == null || (name = instance.value("name")) == null) continue;
            try {
                definitions.put(name.asString(), cl.loadClass(ci.name().toString()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableMap(definitions);
    }

    protected Stream<ClassInfo> implementors(DotName type) {
        ClassLoader cl = this.getClassLoader();
        IndexView view = GenerateYamlSupport.getCompositeIndexer(cl);
        return view.getAllKnownImplementors(type).stream();
    }

    protected Stream<ClassInfo> annotated(DotName type) {
        ClassLoader cl = this.getClassLoader();
        IndexView view = GenerateYamlSupport.getCompositeIndexer(cl);
        return view.getAnnotations(type).stream().map(AnnotationInstance::target).filter(t -> t.kind() == AnnotationTarget.Kind.CLASS).map(AnnotationTarget::asClass);
    }

    protected static IndexView getCompositeIndexer(ClassLoader classLoader) {
        try {
            Enumeration<URL> elements = classLoader.getResources("META-INF/jandex.idx");
            ArrayList<Index> allIndex = new ArrayList<Index>();
            HashSet<URL> locations = new HashSet<URL>();
            Enumeration<URL> e = elements;
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                if (!locations.add(url)) continue;
                InputStream is = url.openStream();
                Throwable throwable = null;
                try {
                    allIndex.add(new IndexReader(is).read());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            return CompositeIndex.create(allIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ClassLoader getClassLoader() {
        if (this.project == null) {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
        try {
            ArrayList elements = new ArrayList();
            elements.addAll(this.project.getCompileClasspathElements());
            URL[] urls = new URL[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                urls[i] = new File((String)elements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }
}

