/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.k.tooling.maven.model.Artifact;
import org.apache.camel.k.tooling.maven.model.CamelScheme;

public class CamelArtifact
extends Artifact {
    private List<CamelScheme> schemes = new ArrayList<CamelScheme>();
    private List<String> languages = new ArrayList<String>();
    private List<String> dataformats = new ArrayList<String>();
    private List<Artifact> dependencies = new ArrayList<Artifact>();
    private List<Artifact> exclusions = new ArrayList<Artifact>();
    private List<String> javaTypes = new ArrayList<String>();

    public void setSchemes(List<CamelScheme> schemes) {
        this.schemes = schemes;
    }

    public void addScheme(CamelScheme scheme) {
        if (!this.schemes.contains(scheme)) {
            this.schemes.add(scheme);
        }
    }

    public List<String> getLanguages() {
        return this.languages;
    }

    public void setLanguages(List<String> languages) {
        this.languages = languages;
    }

    public void addLanguage(String language) {
        if (!this.languages.contains(language)) {
            this.languages.add(language);
        }
    }

    public List<String> getDataformats() {
        return this.dataformats;
    }

    public void setDataformats(List<String> dataformats) {
        this.dataformats = dataformats;
    }

    public void addDataformats(String dataformat) {
        if (!this.dataformats.contains(dataformat)) {
            this.dataformats.add(dataformat);
        }
    }

    public List<CamelScheme> getSchemes() {
        return this.schemes;
    }

    public Optional<CamelScheme> getScheme(String id) {
        return this.schemes.stream().filter(s -> Objects.equals(s.getId(), id)).findFirst();
    }

    public CamelScheme createScheme(String id) {
        for (CamelScheme scheme : this.schemes) {
            if (!scheme.getId().equals(id)) continue;
            return scheme;
        }
        CamelScheme answer = new CamelScheme();
        answer.setId(id);
        this.schemes.add(answer);
        return answer;
    }

    public List<Artifact> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Artifact> dependencies) {
        this.dependencies = dependencies;
    }

    public void addDependency(Artifact dependency) {
        if (!this.dependencies.contains(dependency)) {
            this.dependencies.add(dependency);
        }
    }

    public void addDependency(String groupId, String artifactId) {
        Artifact artifact = new Artifact();
        artifact.setGroupId(groupId);
        artifact.setArtifactId(artifactId);
        this.addDependency(artifact);
    }

    public void addDependency(String groupId, String artifactId, String version) {
        Artifact artifact = new Artifact();
        artifact.setGroupId(groupId);
        artifact.setArtifactId(artifactId);
        artifact.setVersion(version);
        this.addDependency(artifact);
    }

    public List<Artifact> getExclusions() {
        return this.exclusions;
    }

    public void setExclusions(List<Artifact> exclusions) {
        this.exclusions = exclusions;
    }

    public void addExclusion(Artifact exclusion) {
        if (!this.exclusions.contains(exclusion)) {
            this.exclusions.add(exclusion);
        }
    }

    public void addExclusion(String groupId, String artifactId) {
        Artifact artifact = new Artifact();
        artifact.setGroupId(groupId);
        artifact.setArtifactId(artifactId);
        this.addExclusion(artifact);
    }

    public List<String> getJavaTypes() {
        return this.javaTypes;
    }

    public void setJavaTypes(List<String> javaTypes) {
        this.javaTypes = javaTypes;
    }

    public void addJavaType(String javaType) {
        if (!this.javaTypes.contains(javaType)) {
            this.javaTypes.add(javaType);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CamelArtifact artifact = (CamelArtifact)o;
        return Objects.equals(this.getArtifactId(), artifact.getArtifactId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getArtifactId());
    }
}

