package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RuntimeProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new RuntimeProvider.Builder()}.
 */
@Generated(from = "RuntimeProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableRuntimeProvider
    implements RuntimeProvider {
  private final QuarkusRuntimeProvider quarkus;

  private ImmutableRuntimeProvider(QuarkusRuntimeProvider quarkus) {
    this.quarkus = quarkus;
  }

  /**
   * @return The value of the {@code quarkus} attribute
   */
  @JsonProperty("quarkus")
  @Override
  public Optional<QuarkusRuntimeProvider> getQuarkus() {
    return Optional.ofNullable(quarkus);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link RuntimeProvider#getQuarkus() quarkus} attribute.
   * @param value The value for quarkus
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRuntimeProvider withQuarkus(QuarkusRuntimeProvider value) {
    QuarkusRuntimeProvider newValue = Objects.requireNonNull(value, "quarkus");
    if (this.quarkus == newValue) return this;
    return new ImmutableRuntimeProvider(newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link RuntimeProvider#getQuarkus() quarkus} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for quarkus
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableRuntimeProvider withQuarkus(Optional<? extends QuarkusRuntimeProvider> optional) {
    QuarkusRuntimeProvider value = optional.orElse(null);
    if (this.quarkus == value) return this;
    return new ImmutableRuntimeProvider(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRuntimeProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRuntimeProvider
        && equalTo((ImmutableRuntimeProvider) another);
  }

  private boolean equalTo(ImmutableRuntimeProvider another) {
    return Objects.equals(quarkus, another.quarkus);
  }

  /**
   * Computes a hash code from attributes: {@code quarkus}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(quarkus);
    return h;
  }

  /**
   * Prints the immutable value {@code RuntimeProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RuntimeProvider")
        .omitNullValues()
        .add("quarkus", quarkus)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RuntimeProvider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RuntimeProvider instance
   */
  public static ImmutableRuntimeProvider copyOf(RuntimeProvider instance) {
    if (instance instanceof ImmutableRuntimeProvider) {
      return (ImmutableRuntimeProvider) instance;
    }
    return new RuntimeProvider.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableRuntimeProvider ImmutableRuntimeProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RuntimeProvider", generator = "Immutables")
  @JsonPropertyOrder("quarkus")
  public static class Builder {
    private QuarkusRuntimeProvider quarkus;

    /**
     * Creates a builder for {@link ImmutableRuntimeProvider ImmutableRuntimeProvider} instances.
     * <pre>
     * new RuntimeProvider.Builder()
     *    .quarkus(org.apache.camel.k.tooling.maven.model.crd.QuarkusRuntimeProvider) // optional {@link RuntimeProvider#getQuarkus() quarkus}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof RuntimeProvider.Builder)) {
        throw new UnsupportedOperationException("Use: new RuntimeProvider.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code RuntimeProvider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final RuntimeProvider.Builder from(RuntimeProvider instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<QuarkusRuntimeProvider> quarkusOptional = instance.getQuarkus();
      if (quarkusOptional.isPresent()) {
        quarkus(quarkusOptional);
      }
      return (RuntimeProvider.Builder) this;
    }

    /**
     * Initializes the optional value {@link RuntimeProvider#getQuarkus() quarkus} to quarkus.
     * @param quarkus The value for quarkus
     * @return {@code this} builder for chained invocation
     */
    public final RuntimeProvider.Builder quarkus(QuarkusRuntimeProvider quarkus) {
      this.quarkus = Objects.requireNonNull(quarkus, "quarkus");
      return (RuntimeProvider.Builder) this;
    }

    /**
     * Initializes the optional value {@link RuntimeProvider#getQuarkus() quarkus} to quarkus.
     * @param quarkus The value for quarkus
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quarkus")
    public final RuntimeProvider.Builder quarkus(Optional<? extends QuarkusRuntimeProvider> quarkus) {
      this.quarkus = quarkus.orElse(null);
      return (RuntimeProvider.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableRuntimeProvider ImmutableRuntimeProvider}.
     * @return An immutable instance of RuntimeProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRuntimeProvider build() {
      return new ImmutableRuntimeProvider(quarkus);
    }
  }
}
