package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QuarkusRuntimeProvider}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new QuarkusRuntimeProvider.Builder()}.
 */
@Generated(from = "QuarkusRuntimeProvider", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableQuarkusRuntimeProvider
    implements QuarkusRuntimeProvider {
  private final String camelQuarkusVersion;
  private final String quarkusVersion;

  private ImmutableQuarkusRuntimeProvider(String camelQuarkusVersion, String quarkusVersion) {
    this.camelQuarkusVersion = camelQuarkusVersion;
    this.quarkusVersion = quarkusVersion;
  }

  /**
   * @return The value of the {@code camelQuarkusVersion} attribute
   */
  @JsonProperty("camelQuarkusVersion")
  @Override
  public String getCamelQuarkusVersion() {
    return camelQuarkusVersion;
  }

  /**
   * @return The value of the {@code quarkusVersion} attribute
   */
  @JsonProperty("quarkusVersion")
  @Override
  public String getQuarkusVersion() {
    return quarkusVersion;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuarkusRuntimeProvider#getCamelQuarkusVersion() camelQuarkusVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for camelQuarkusVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuarkusRuntimeProvider withCamelQuarkusVersion(String value) {
    String newValue = Objects.requireNonNull(value, "camelQuarkusVersion");
    if (this.camelQuarkusVersion.equals(newValue)) return this;
    return new ImmutableQuarkusRuntimeProvider(newValue, this.quarkusVersion);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QuarkusRuntimeProvider#getQuarkusVersion() quarkusVersion} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for quarkusVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQuarkusRuntimeProvider withQuarkusVersion(String value) {
    String newValue = Objects.requireNonNull(value, "quarkusVersion");
    if (this.quarkusVersion.equals(newValue)) return this;
    return new ImmutableQuarkusRuntimeProvider(this.camelQuarkusVersion, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQuarkusRuntimeProvider} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQuarkusRuntimeProvider
        && equalTo((ImmutableQuarkusRuntimeProvider) another);
  }

  private boolean equalTo(ImmutableQuarkusRuntimeProvider another) {
    return camelQuarkusVersion.equals(another.camelQuarkusVersion)
        && quarkusVersion.equals(another.quarkusVersion);
  }

  /**
   * Computes a hash code from attributes: {@code camelQuarkusVersion}, {@code quarkusVersion}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + camelQuarkusVersion.hashCode();
    h += (h << 5) + quarkusVersion.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QuarkusRuntimeProvider} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QuarkusRuntimeProvider")
        .omitNullValues()
        .add("camelQuarkusVersion", camelQuarkusVersion)
        .add("quarkusVersion", quarkusVersion)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link QuarkusRuntimeProvider} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QuarkusRuntimeProvider instance
   */
  public static ImmutableQuarkusRuntimeProvider copyOf(QuarkusRuntimeProvider instance) {
    if (instance instanceof ImmutableQuarkusRuntimeProvider) {
      return (ImmutableQuarkusRuntimeProvider) instance;
    }
    return new QuarkusRuntimeProvider.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableQuarkusRuntimeProvider ImmutableQuarkusRuntimeProvider}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QuarkusRuntimeProvider", generator = "Immutables")
  @JsonPropertyOrder({"camelQuarkusVersion", "quarkusVersion"})
  public static class Builder {
    private static final long INIT_BIT_CAMEL_QUARKUS_VERSION = 0x1L;
    private static final long INIT_BIT_QUARKUS_VERSION = 0x2L;
    private long initBits = 0x3L;

    private String camelQuarkusVersion;
    private String quarkusVersion;

    /**
     * Creates a builder for {@link ImmutableQuarkusRuntimeProvider ImmutableQuarkusRuntimeProvider} instances.
     * <pre>
     * new QuarkusRuntimeProvider.Builder()
     *    .camelQuarkusVersion(String) // required {@link QuarkusRuntimeProvider#getCamelQuarkusVersion() camelQuarkusVersion}
     *    .quarkusVersion(String) // required {@link QuarkusRuntimeProvider#getQuarkusVersion() quarkusVersion}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof QuarkusRuntimeProvider.Builder)) {
        throw new UnsupportedOperationException("Use: new QuarkusRuntimeProvider.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code QuarkusRuntimeProvider} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final QuarkusRuntimeProvider.Builder from(QuarkusRuntimeProvider instance) {
      Objects.requireNonNull(instance, "instance");
      camelQuarkusVersion(instance.getCamelQuarkusVersion());
      quarkusVersion(instance.getQuarkusVersion());
      return (QuarkusRuntimeProvider.Builder) this;
    }

    /**
     * Initializes the value for the {@link QuarkusRuntimeProvider#getCamelQuarkusVersion() camelQuarkusVersion} attribute.
     * @param camelQuarkusVersion The value for camelQuarkusVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("camelQuarkusVersion")
    public final QuarkusRuntimeProvider.Builder camelQuarkusVersion(String camelQuarkusVersion) {
      this.camelQuarkusVersion = Objects.requireNonNull(camelQuarkusVersion, "camelQuarkusVersion");
      initBits &= ~INIT_BIT_CAMEL_QUARKUS_VERSION;
      return (QuarkusRuntimeProvider.Builder) this;
    }

    /**
     * Initializes the value for the {@link QuarkusRuntimeProvider#getQuarkusVersion() quarkusVersion} attribute.
     * @param quarkusVersion The value for quarkusVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("quarkusVersion")
    public final QuarkusRuntimeProvider.Builder quarkusVersion(String quarkusVersion) {
      this.quarkusVersion = Objects.requireNonNull(quarkusVersion, "quarkusVersion");
      initBits &= ~INIT_BIT_QUARKUS_VERSION;
      return (QuarkusRuntimeProvider.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableQuarkusRuntimeProvider ImmutableQuarkusRuntimeProvider}.
     * @return An immutable instance of QuarkusRuntimeProvider
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQuarkusRuntimeProvider build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQuarkusRuntimeProvider(camelQuarkusVersion, quarkusVersion);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CAMEL_QUARKUS_VERSION) != 0) attributes.add("camelQuarkusVersion");
      if ((initBits & INIT_BIT_QUARKUS_VERSION) != 0) attributes.add("quarkusVersion");
      return "Cannot build QuarkusRuntimeProvider, some of required attributes are not set " + attributes;
    }
  }
}
