/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;

@Mojo(name="generate-yaml-support-classes", inheritByDefault=false, defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.COMPILE, threadSafe=true, requiresProject=false)
public class GenerateYamlSupportClasses
extends AbstractMojo {
    public static final DotName EXPRESSION_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.language.ExpressionDefinition");
    public static final DotName DATAFORMAT_DEFINITION_CLASS = DotName.createSimple((String)"org.apache.camel.model.DataFormatDefinition");
    public static final DotName XMLROOTELEMENT_ANNOTATION_CLASS = DotName.createSimple((String)"javax.xml.bind.annotation.XmlRootElement");
    @Parameter(readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-sources/camel")
    private String output;

    public void execute() throws MojoFailureException {
        try {
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasExpression()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml.parser", (TypeSpec)this.generateHasDataFormat()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
            JavaFile.builder((String)"org.apache.camel.k.loader.yaml", (TypeSpec)this.generateJacksonModule()).indent("    ").build().writeTo(Paths.get(this.output, new String[0]));
        }
        catch (IOException e) {
            throw new MojoFailureException(e.getMessage());
        }
    }

    public final TypeSpec generateHasExpression() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasExpression");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(MethodSpec.methodBuilder((String)"setExpression").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ExpressionDefinition.class, "expressionDefinition", new Modifier[0]).addAnnotation(AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.WRAPPER_OBJECT"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"getExpression").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(ExpressionDefinition.class).build());
        this.definitions(EXPRESSION_DEFINITION_CLASS).forEach((k, v) -> {
            String name = k;
            name = WordUtils.capitalize((String)name, (char[])new char[]{'_', '-'});
            name = StringUtils.remove((String)name, (String)"_");
            name = StringUtils.remove((String)name, (String)"-");
            type.addMethod(MethodSpec.methodBuilder((String)("set" + name)).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "$S", new Object[]{k}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((Type)v, "definition", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (getExpression() != null)", new Object[0]).addStatement("throw new IllegalArgumentException(\"And expression has already been set\")", new Object[0]).endControlFlow().addStatement("setExpression(definition);", new Object[0]).build()).build());
        });
        return type.build();
    }

    public final TypeSpec generateHasDataFormat() {
        TypeSpec.Builder type = TypeSpec.interfaceBuilder((String)"HasDataFormat");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC});
        type.addMethod(MethodSpec.methodBuilder((String)"setDataFormatType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(DataFormatDefinition.class, "dataFormatType", new Modifier[0]).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "{$S, $S}", new Object[]{"data-format-type", "data-format"}).build()).addAnnotation(AnnotationSpec.builder(JsonTypeInfo.class).addMember("use", "$L", new Object[]{"JsonTypeInfo.Id.NAME"}).addMember("include", "$L", new Object[]{"JsonTypeInfo.As.WRAPPER_OBJECT"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"getDataFormatType").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns(DataFormatDefinition.class).build());
        this.definitions(DATAFORMAT_DEFINITION_CLASS).forEach((k, v) -> {
            String name = k;
            name = WordUtils.capitalize((String)name, (char[])new char[]{'_', '-'});
            name = StringUtils.remove((String)name, (String)"_");
            name = StringUtils.remove((String)name, (String)"-");
            type.addMethod(MethodSpec.methodBuilder((String)("set" + name)).addAnnotation(AnnotationSpec.builder(JsonAlias.class).addMember("value", "$S", new Object[]{k}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.DEFAULT}).addParameter((Type)v, "definition", new Modifier[0]).addCode(CodeBlock.builder().beginControlFlow("if (getDataFormatType() != null)", new Object[0]).addStatement("throw new IllegalArgumentException(\"A data format has already been set\")", new Object[0]).endControlFlow().addStatement("setDataFormatType(definition);", new Object[0]).build()).build());
        });
        return type.build();
    }

    public final TypeSpec generateJacksonModule() {
        TypeSpec.Builder type = TypeSpec.classBuilder((String)"YamlModule");
        type.addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
        type.superclass(Module.class);
        type.addMethod(MethodSpec.methodBuilder((String)"getModuleName").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(String.class).addCode(CodeBlock.builder().addStatement("return $S", new Object[]{"camel-yaml"}).build()).build());
        type.addMethod(MethodSpec.methodBuilder((String)"version").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(Version.class).addCode(CodeBlock.builder().addStatement("return $L", new Object[]{"Version.unknownVersion()"}).build()).build());
        MethodSpec.Builder mb = MethodSpec.methodBuilder((String)"setupModule").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(Module.SetupContext.class, "context", new Modifier[0]);
        this.definitions(EXPRESSION_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($T.class, $S))", new Object[]{v, k}));
        this.definitions(DATAFORMAT_DEFINITION_CLASS).forEach((k, v) -> mb.addStatement("context.registerSubtypes(new com.fasterxml.jackson.databind.jsontype.NamedType($T.class, $S))", new Object[]{v, k}));
        type.addMethod(mb.build());
        return type.build();
    }

    private Map<String, Class<?>> definitions(DotName type) {
        ClassLoader cl = this.getClassLoader();
        HashMap definitions = new HashMap();
        IndexView view = GenerateYamlSupportClasses.getCompositeIndexer(cl);
        for (ClassInfo ci : view.getAllKnownSubclasses(type)) {
            AnnotationValue name;
            AnnotationInstance instance = ci.classAnnotation(XMLROOTELEMENT_ANNOTATION_CLASS);
            if (instance == null || (name = instance.value("name")) == null) continue;
            try {
                definitions.put(name.asString(), cl.loadClass(ci.name().toString()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableMap(definitions);
    }

    private static IndexView getCompositeIndexer(ClassLoader classLoader) {
        try {
            Enumeration<URL> elements = classLoader.getResources("META-INF/jandex.idx");
            ArrayList<Index> allIndex = new ArrayList<Index>();
            Enumeration<URL> e = elements;
            while (e.hasMoreElements()) {
                InputStream is = e.nextElement().openStream();
                Throwable throwable = null;
                try {
                    allIndex.add(new IndexReader(is).read());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
            return CompositeIndex.create(allIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ClassLoader getClassLoader() {
        if (this.project == null) {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
        try {
            ArrayList elements = new ArrayList();
            elements.addAll(this.project.getCompileClasspathElements());
            elements.addAll(this.project.getRuntimeClasspathElements());
            URL[] urls = new URL[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                urls[i] = new File((String)elements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            return ((Object)((Object)this)).getClass().getClassLoader();
        }
    }
}

