/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.processors;

import com.vdurmont.semver4j.Semver;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.apache.camel.k.tooling.maven.model.CatalogProcessor;
import org.apache.maven.project.MavenProject;

public class CatalogProcessor3x
implements CatalogProcessor {
    private static final List<String> KNOWN_HTTP_URIS = Arrays.asList("ahc", "ahc-ws", "atmosphere-websocket", "cxf", "cxfrs", "grpc", "jetty", "netty-http", "rest", "restlet", "servlet", "spark-rest", "spring-ws", "undertow", "webhook", "websocket");
    private static final List<String> KNOWN_PASSIVE_URIS = Arrays.asList("bean", "binding", "browse", "class", "controlbus", "dataformat", "dataset", "direct", "direct-vm", "language", "log", "mock", "properties", "ref", "seda", "stub", "test", "validator", "vm");

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    @Override
    public boolean accepts(CamelCatalog catalog) {
        Semver semver = new Semver(catalog.getCatalogVersion(), Semver.SemverType.IVY);
        return semver.isGreaterThan("2.999.999") && semver.isLowerThan("4.0.0");
    }

    @Override
    public void process(MavenProject project, CamelCatalog catalog, Map<String, CamelArtifact> artifacts) {
        CamelArtifact artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-main");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-core-engine");
        artifact2.addDependency("org.apache.camel", "camel-main");
        artifact2.addDependency("org.apache.camel", "camel-properties");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-loader-groovy");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-endpointdsl");
        artifact2.addDependency("org.apache.camel", "camel-groovy");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-loader-kotlin");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-endpointdsl");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-loader-js");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-endpointdsl");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-loader-xml");
        artifact2.setVersion(project.getVersion());
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-loader-java");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel", "camel-endpointdsl");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-loader-knative");
        artifact2.setVersion(project.getVersion());
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-knative");
        artifact2.setVersion(project.getVersion());
        artifact2.createScheme("knative").setHttp(true);
        artifact2.addDependency("org.apache.camel", "camel-cloud");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-health");
        artifact2.addDependency("org.apache.camel", "camel-servlet");
        artifact2.addDependency("org.apache.camel.k", "camel-k-runtime-servlet");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-servlet");
        artifact2.addDependency("org.apache.camel", "camel-servlet");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-knative");
        artifact2.addDependency("org.apache.camel", "camel-cloud");
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-yaml");
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-knative");
        artifact2.addDependency("org.apache.camel.k", "camel-knative");
        artifact2.addDependency("org.apache.camel.k", "camel-knative-http");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-jvm");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel.k", "camel-k-runtime-main");
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-js");
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-xml");
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-java");
        artifact2.addDependency("org.apache.camel", "camel-core-engine");
        artifact2.addDependency("org.apache.camel", "camel-main");
        artifact2.addDependency("org.apache.camel", "camel-properties");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-groovy");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-groovy");
        artifact2.addDependency("org.apache.camel", "camel-groovy");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-kotlin");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-kotlin");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        artifact2 = new CamelArtifact();
        artifact2.setGroupId("org.apache.camel.k");
        artifact2.setArtifactId("camel-k-runtime-yaml");
        artifact2.setVersion(project.getVersion());
        artifact2.addDependency("org.apache.camel.k", "camel-k-loader-yaml");
        artifacts.put(artifact2.getArtifactId(), artifact2);
        for (String scheme : KNOWN_HTTP_URIS) {
            artifacts.values().forEach(artifact -> artifact.getScheme(scheme).ifPresent(s -> s.setHttp(true)));
        }
        for (String scheme : KNOWN_PASSIVE_URIS) {
            artifacts.values().forEach(artifact -> artifact.getScheme(scheme).ifPresent(s -> s.setPassive(true)));
        }
        artifacts.computeIfPresent("camel-http", (key, artifact) -> {
            artifact.addDependency("org.apache.camel", "camel-file");
            return artifact;
        });
    }
}

