/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven.model.k8s;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.camel.k.tooling.maven.model.k8s.ObjectMeta;
import org.immutables.value.Generated;

@Generated(from="ObjectMeta", generator="Immutables")
public final class ImmutableObjectMeta
implements ObjectMeta {
    private final String name;
    private final ImmutableMap<String, String> labels;

    private ImmutableObjectMeta(Builder builder) {
        this.name = builder.name;
        this.labels = builder.labelsIsSet() ? builder.labels.build() : ImmutableMap.copyOf(ObjectMeta.super.getLabels());
    }

    private ImmutableObjectMeta(String name, ImmutableMap<String, String> labels) {
        this.name = name;
        this.labels = labels;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="labels")
    public ImmutableMap<String, String> getLabels() {
        return this.labels;
    }

    public final ImmutableObjectMeta withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableObjectMeta(newValue, this.labels);
    }

    public final ImmutableObjectMeta withLabels(Map<String, ? extends String> entries) {
        if (this.labels == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableObjectMeta(this.name, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableObjectMeta && this.equalTo((ImmutableObjectMeta)another);
    }

    private boolean equalTo(ImmutableObjectMeta another) {
        return this.name.equals(another.name) && this.labels.equals(another.labels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.labels.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ObjectMeta").omitNullValues().add("name", (Object)this.name).add("labels", this.labels).toString();
    }

    public static ImmutableObjectMeta copyOf(ObjectMeta instance) {
        if (instance instanceof ImmutableObjectMeta) {
            return (ImmutableObjectMeta)instance;
        }
        return new ObjectMeta.Builder().from(instance).build();
    }

    @Generated(from="ObjectMeta", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long OPT_BIT_LABELS = 1L;
        private long initBits = 1L;
        private long optBits;
        private String name;
        private ImmutableMap.Builder<String, String> labels = ImmutableMap.builder();

        public Builder() {
            if (!(this instanceof ObjectMeta.Builder)) {
                throw new UnsupportedOperationException("Use: new ObjectMeta.Builder()");
            }
        }

        @CanIgnoreReturnValue
        public final ObjectMeta.Builder from(ObjectMeta instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.getName());
            this.putAllLabels(instance.getLabels());
            return (ObjectMeta.Builder)this;
        }

        @JsonProperty(value="name")
        @CanIgnoreReturnValue
        public final ObjectMeta.Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (ObjectMeta.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ObjectMeta.Builder putLabels(String key, String value) {
            this.labels.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return (ObjectMeta.Builder)this;
        }

        @CanIgnoreReturnValue
        public final ObjectMeta.Builder putLabels(Map.Entry<String, ? extends String> entry) {
            this.labels.put(entry);
            this.optBits |= 1L;
            return (ObjectMeta.Builder)this;
        }

        @JsonProperty(value="labels")
        @CanIgnoreReturnValue
        public final ObjectMeta.Builder labels(Map<String, ? extends String> entries) {
            this.labels = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllLabels(entries);
        }

        @CanIgnoreReturnValue
        public final ObjectMeta.Builder putAllLabels(Map<String, ? extends String> entries) {
            this.labels.putAll(entries);
            this.optBits |= 1L;
            return (ObjectMeta.Builder)this;
        }

        public ImmutableObjectMeta build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableObjectMeta(this);
        }

        private boolean labelsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build ObjectMeta, some of required attributes are not set " + attributes;
        }
    }
}

