/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.k.tooling.maven;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.StringUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

@Mojo(name="generate-dependency-list", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateDependencyListMojo
extends AbstractMojo {
    @Parameter(readonly=true, defaultValue="${project}")
    private MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/dependencies.yaml")
    private String outputFile;
    @Parameter(defaultValue="true")
    private boolean includeLocation;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Path output = Paths.get(this.outputFile, new String[0]);
        try {
            if (Files.notExists(output.getParent(), new LinkOption[0])) {
                Files.createDirectories(output.getParent(), new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating dependencies list", (Exception)e);
        }
        try (BufferedWriter writer = Files.newBufferedWriter(output, StandardCharsets.UTF_8, new OpenOption[0]);){
            List deps = this.project.getArtifacts().stream().filter(this::isCompileOrRuntime).map(this::artifactToMap).collect(Collectors.toList());
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            Yaml yaml = new Yaml(options);
            yaml.dump(Collections.singletonMap("dependencies", deps), (Writer)writer);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Exception while generating dependencies list", (Exception)e);
        }
    }

    private boolean isCompileOrRuntime(Artifact artifact) {
        return StringUtils.equals((String)artifact.getScope(), (String)"compile") || StringUtils.equals((String)artifact.getScope(), (String)"runtime");
    }

    private Map<String, String> artifactToMap(Artifact artifact) {
        HashMap<String, String> dep = new HashMap<String, String>();
        dep.put("id", artifact.getId());
        if (this.includeLocation && artifact.getFile() != null) {
            dep.put("location", artifact.getFile().getAbsolutePath());
        }
        return dep;
    }
}

