package org.apache.camel.k.tooling.maven.model.crd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.camel.k.tooling.maven.model.CamelArtifact;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link CamelCatalogSpec}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new CamelCatalogSpec.Builder()}.
 */
@Generated(from = "CamelCatalogSpec", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableCamelCatalogSpec
    implements CamelCatalogSpec {
  private final String version;
  private final SortedMap<String, CamelArtifact> artifacts;

  private ImmutableCamelCatalogSpec(ImmutableCamelCatalogSpec.Builder builder) {
    this.version = builder.version;
    this.artifacts = builder.artifacts != null
        ? builder.artifacts
        : Objects.requireNonNull(CamelCatalogSpec.super.getArtifacts(), "artifacts");
  }

  private ImmutableCamelCatalogSpec(
      String version,
      SortedMap<String, CamelArtifact> artifacts) {
    this.version = version;
    this.artifacts = artifacts;
  }

  /**
   * @return The value of the {@code version} attribute
   */
  @JsonProperty("version")
  @Override
  public String getVersion() {
    return version;
  }

  /**
   * @return The value of the {@code artifacts} attribute
   */
  @JsonProperty("artifacts")
  @Override
  public SortedMap<String, CamelArtifact> getArtifacts() {
    return artifacts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalogSpec#getVersion() version} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for version
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalogSpec withVersion(String value) {
    String newValue = Objects.requireNonNull(value, "version");
    if (this.version.equals(newValue)) return this;
    return new ImmutableCamelCatalogSpec(newValue, this.artifacts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CamelCatalogSpec#getArtifacts() artifacts} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for artifacts
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCamelCatalogSpec withArtifacts(SortedMap<String, CamelArtifact> value) {
    if (this.artifacts == value) return this;
    SortedMap<String, CamelArtifact> newValue = Objects.requireNonNull(value, "artifacts");
    return new ImmutableCamelCatalogSpec(this.version, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCamelCatalogSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCamelCatalogSpec
        && equalTo((ImmutableCamelCatalogSpec) another);
  }

  private boolean equalTo(ImmutableCamelCatalogSpec another) {
    return version.equals(another.version)
        && artifacts.equals(another.artifacts);
  }

  /**
   * Computes a hash code from attributes: {@code version}, {@code artifacts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + version.hashCode();
    h += (h << 5) + artifacts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CamelCatalogSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CamelCatalogSpec")
        .omitNullValues()
        .add("version", version)
        .add("artifacts", artifacts)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CamelCatalogSpec} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CamelCatalogSpec instance
   */
  public static ImmutableCamelCatalogSpec copyOf(CamelCatalogSpec instance) {
    if (instance instanceof ImmutableCamelCatalogSpec) {
      return (ImmutableCamelCatalogSpec) instance;
    }
    return new CamelCatalogSpec.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableCamelCatalogSpec ImmutableCamelCatalogSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CamelCatalogSpec", generator = "Immutables")
  @JsonPropertyOrder({"version", "artifacts"})
  public static class Builder {
    private static final long INIT_BIT_VERSION = 0x1L;
    private long initBits = 0x1L;

    private String version;
    private SortedMap<String, CamelArtifact> artifacts;

    /**
     * Creates a builder for {@link ImmutableCamelCatalogSpec ImmutableCamelCatalogSpec} instances.
     * <pre>
     * new CamelCatalogSpec.Builder()
     *    .version(String) // required {@link CamelCatalogSpec#getVersion() version}
     *    .artifacts(SortedMap&lt;String, org.apache.camel.k.tooling.maven.model.CamelArtifact&gt;) // optional {@link CamelCatalogSpec#getArtifacts() artifacts}
     *    .build();
     * </pre>
     */
    public Builder() {
      if (!(this instanceof CamelCatalogSpec.Builder)) {
        throw new UnsupportedOperationException("Use: new CamelCatalogSpec.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code CamelCatalogSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final CamelCatalogSpec.Builder from(CamelCatalogSpec instance) {
      Objects.requireNonNull(instance, "instance");
      version(instance.getVersion());
      artifacts(instance.getArtifacts());
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalogSpec#getVersion() version} attribute.
     * @param version The value for version 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final CamelCatalogSpec.Builder version(String version) {
      this.version = Objects.requireNonNull(version, "version");
      initBits &= ~INIT_BIT_VERSION;
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Initializes the value for the {@link CamelCatalogSpec#getArtifacts() artifacts} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CamelCatalogSpec#getArtifacts() artifacts}.</em>
     * @param artifacts The value for artifacts 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("artifacts")
    public final CamelCatalogSpec.Builder artifacts(SortedMap<String, CamelArtifact> artifacts) {
      this.artifacts = Objects.requireNonNull(artifacts, "artifacts");
      return (CamelCatalogSpec.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableCamelCatalogSpec ImmutableCamelCatalogSpec}.
     * @return An immutable instance of CamelCatalogSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCamelCatalogSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCamelCatalogSpec(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VERSION) != 0) attributes.add("version");
      return "Cannot build CamelCatalogSpec, some of required attributes are not set " + attributes;
    }
  }
}
