/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper;

import org.apache.camel.component.zookeeper.ConnectionHolder;
import org.apache.camel.component.zookeeper.ZooKeeperConfiguration;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperConnectionManager {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperConnectionManager.class);
    private ZookeeperConnectionStrategy strategy;

    public ZooKeeperConnectionManager(ZooKeeperEndpoint endpoint) {
        this.strategy = new DefaultZookeeperConnectionStrategy(endpoint);
    }

    public ZooKeeper getConnection() {
        return this.strategy.getConnection().getZooKeeper();
    }

    public void shutdown() {
        this.strategy.shutdown();
    }

    private static class DefaultZookeeperConnectionStrategy
    implements ZookeeperConnectionStrategy {
        private ConnectionHolder holder;
        private ZooKeeperConfiguration configuration;

        DefaultZookeeperConnectionStrategy(ZooKeeperEndpoint endpoint) {
            this.configuration = endpoint.getConfiguration();
            LOG.debug("Creating connection to ZooKeeper: {}", (Object)this.configuration);
            this.holder = new ConnectionHolder(this.configuration);
        }

        @Override
        public ConnectionHolder getConnection() {
            return this.holder;
        }

        @Override
        public void shutdown() {
            LOG.debug("Shutting down connection to ZooKeeper: {}", (Object)this.configuration);
            this.holder.closeConnection();
        }
    }

    private static interface ZookeeperConnectionStrategy {
        public ConnectionHolder getConnection();

        public void shutdown();
    }
}

