/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.cluster;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.cluster.CamelClusterMember;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.support.cluster.AbstractCamelClusterView;
import org.apache.camel.support.task.ForegroundTask;
import org.apache.camel.support.task.Tasks;
import org.apache.camel.support.task.budget.Budgets;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.util.ObjectHelper;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.curator.framework.recipes.leader.Participant;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ZooKeeperClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZooKeeperClusterView.class);
    private final ZooKeeperCuratorConfiguration configuration;
    private final CuratorFramework client;
    private final CuratorLocalMember localMember = new CuratorLocalMember();
    private volatile LeaderSelector leaderSelector;

    public ZooKeeperClusterView(CamelClusterService cluster, ZooKeeperCuratorConfiguration configuration, CuratorFramework client, String namespace) {
        super(cluster, namespace);
        this.configuration = configuration;
        this.client = client;
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public Optional<CamelClusterMember> getLeader() {
        if (this.leaderSelector == null || this.isStoppingOrStopped()) {
            return Optional.empty();
        }
        try {
            Participant participant = this.leaderSelector.getLeader();
            return ObjectHelper.equal((Object)participant.getId(), (Object)this.localMember.getId()) ? Optional.of(this.localMember) : Optional.of(new CuratorClusterMember(participant));
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.debug("Failed to get get master because node '{}' does not yet exist (error: '{}')", (Object)this.getFullPath(), (Object)e.getMessage());
            return Optional.empty();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public List<CamelClusterMember> getMembers() {
        if (this.leaderSelector == null) {
            return Collections.emptyList();
        }
        try {
            return this.leaderSelector.getParticipants().stream().map(x$0 -> new CuratorClusterMember((Participant)x$0)).collect(Collectors.toList());
        }
        catch (KeeperException.NoNodeException e) {
            LOGGER.debug("Failed to get members because node '{}' does not yet exist (error: '{}')", (Object)this.getFullPath(), (Object)e.getMessage());
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        if (this.leaderSelector == null) {
            this.leaderSelector = new LeaderSelector(this.client, this.getFullPath(), (LeaderSelectorListener)new CamelLeaderElectionListener());
            this.leaderSelector.setId(this.getClusterService().getId());
            this.leaderSelector.start();
        } else {
            this.leaderSelector.requeue();
        }
    }

    protected void doStop() throws Exception {
        if (this.leaderSelector != null) {
            this.leaderSelector.interruptLeadership();
            this.fireLeadershipChangedEvent(this.getLeader().orElse(null));
        }
    }

    protected void doShutdown() throws Exception {
        if (this.leaderSelector != null) {
            this.leaderSelector.close();
        }
    }

    private String getFullPath() {
        return this.configuration.getBasePath() + "/" + this.getNamespace();
    }

    private final class CuratorLocalMember
    implements CamelClusterMember {
        private CuratorLocalMember() {
        }

        public boolean isLeader() {
            return ZooKeeperClusterView.this.leaderSelector != null && ZooKeeperClusterView.this.leaderSelector.hasLeadership();
        }

        public boolean isLocal() {
            return true;
        }

        public String getId() {
            return ZooKeeperClusterView.this.getClusterService().getId();
        }
    }

    private final class CuratorClusterMember
    implements CamelClusterMember {
        private final Participant participant;

        CuratorClusterMember(Participant participant) {
            this.participant = participant;
        }

        public String getId() {
            return this.participant.getId();
        }

        public boolean isLocal() {
            return this.participant.getId() != null && ObjectHelper.equal((Object)this.participant.getId(), (Object)ZooKeeperClusterView.this.localMember.getId());
        }

        public boolean isLeader() {
            try {
                return ZooKeeperClusterView.this.leaderSelector.getLeader().equals((Object)this.participant);
            }
            catch (Exception e) {
                LOGGER.debug("{}", (Object)e.getMessage(), (Object)e);
                return false;
            }
        }
    }

    private final class CamelLeaderElectionListener
    extends LeaderSelectorListenerAdapter {
        private CamelLeaderElectionListener() {
        }

        public void takeLeadership(CuratorFramework curatorFramework) throws Exception {
            ZooKeeperClusterView.this.fireLeadershipChangedEvent(ZooKeeperClusterView.this.localMember);
            ForegroundTask task = Tasks.foregroundTask().withBudget((IterationBudget)Budgets.iterationBudget().withMaxIterations(-1).withInterval(Duration.ofSeconds(5L)).build()).build();
            task.run(ZooKeeperClusterView.this.getCamelContext(), () -> !ZooKeeperClusterView.this.isRunAllowed());
            ZooKeeperClusterView.this.fireLeadershipChangedEvent(ZooKeeperClusterView.this.getLeader().orElse(null));
        }
    }
}

