/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ExistsOperation
extends ZooKeeperOperation<String> {
    private boolean mustExist;

    public ExistsOperation(ZooKeeper connection, String node) {
        this(connection, node, true);
    }

    public ExistsOperation(ZooKeeper connection, String node, boolean mustExist) {
        super(connection, node);
        this.mustExist = mustExist;
    }

    @Override
    public OperationResult<String> getResult() {
        try {
            Stat statistics = this.connection.exists(this.node, true);
            boolean ok = this.isOk(statistics);
            if (LOG.isTraceEnabled()) {
                LOG.trace(ok ? "node exists" : "node does not exist");
            }
            return new OperationResult<String>(this.node, statistics, ok);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new OperationResult<String>(e);
        }
        catch (Exception e) {
            return new OperationResult<String>(e);
        }
    }

    private boolean isOk(Stat statistics) {
        boolean ok = false;
        ok = this.mustExist ? statistics != null : statistics == null;
        return ok;
    }
}

