/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.operations;

import java.util.List;
import org.apache.camel.component.zookeeper.operations.OperationResult;
import org.apache.camel.component.zookeeper.operations.ZooKeeperHelper;
import org.apache.camel.component.zookeeper.operations.ZooKeeperOperation;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public class CreateOperation
extends ZooKeeperOperation<String> {
    private static final List<ACL> DEFAULT_PERMISSIONS = ZooDefs.Ids.OPEN_ACL_UNSAFE;
    private static final CreateMode DEFAULT_MODE = CreateMode.EPHEMERAL;
    private byte[] data;
    private List<ACL> permissions = DEFAULT_PERMISSIONS;
    private CreateMode createMode = DEFAULT_MODE;

    public CreateOperation(ZooKeeper connection, String node) {
        super(connection, node);
    }

    @Override
    public OperationResult<String> getResult() {
        try {
            ZooKeeperHelper.mkdirs(this.connection, this.node, false, CreateMode.PERSISTENT);
            String created = this.connection.create(this.node, this.data, this.permissions, this.createMode);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Created node '%s' using mode '%s'", created, this.createMode));
            }
            return new OperationResult<String>(created, new Stat());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new OperationResult<String>(e);
        }
        catch (Exception e) {
            return new OperationResult<String>(e);
        }
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public void setPermissions(List<ACL> permissions) {
        this.permissions = permissions;
    }

    public void setCreateMode(CreateMode createMode) {
        this.createMode = createMode;
    }
}

